/*****************************************************************************\
*                                                                             *
*  ALIGN-MASK    compares predicted  and observed positions of a direct mask  *
*                image to compute corrections to a dewar offset file          *
*                                                                             *
*  VERSION       7 Feb 2004                                                   *
*                                                                             *
*               hidden features; if extra input parameter -c n, do only chip n*
*                                if extra input parameter -p, print x,y,dx,dy *
*                                 q in answers quits program                  *
\*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "ioutils.h"
#include "kdcutil.h"
#include "mgutils.h"
#include "optutils.h"
#include "fitsio.h"
#include "cpgplot.h"
#include "cosmos.h"
#include "clardy.h"

int comp_nums(const float *, const float *);

int  main(int argc,char *argv[]){

  int      irnk[10000],irnk_y[10000],indx[1000][9],chp[5000],aptype[5000],
           bitpix,naxis,nob[9],narg,status,here,i,chip,n,ind,boxwdth,boxht,
           nulvl,halfht,halfwd,nobj,srchbox,nelem,chip1,j,INT,
           magfac,np1,np2,chipnum,anynl,nneg,npos,s1,s2,s3,s4,npr,ntot,n_pairs,
           nchip,contig,k,xcorn,ycorn,bflag,ixp,iyp,ii,jj,ixtop,iytop,ypar,
           fxpxl,fypxl,i1,i2,i3,i4,nx0,nx1,isspec,out,nlines,aver,ibin,ybin;
  int      **array,*image,*INTP,**row,*sbox;
  float    x[5000],y[5000],xs[5000],ys[5000],xd[5000],yd[5000],rank[10000],
           rank_y[10000],apwidth[5000],xccd,yccd,xfp,yfp,xlfp,ylfp,xlcd,ylcd,
           xcd,ycd,x8,y8,dj,xcen,xmid,ymid,dx,dy,sumax,sum,xnew,ynew,scal,xxx,
           yyy,deltax,deltay,avneg,avpos,dtheta,xv,yv,pscale,edge,theta,thetas,
           thetav,xavv,yavv,divid2,sc,scale,xm8,ym8,sumx,sumy,lines[100],bx,by,
           ddx,mnx,mxx,mny,mxy,aspct,wid,xa[2],ya[2],a2,a3,slope,xdd,ydd,sigma,
           t,flmx,flmn,flx,flxrat,lamb,sigma1;
  float    *tlist;
  double   cur_wavl, cur_temp,sc2,x1,x2,y1,y2,xs1,xs2,ys1,ys2,r_1,rs_1,
           xl[5000],yl[5000],xr[5000],yr[5000];
  char     flnm[80],file[80],maskfile[80],imacsdir[133],line[133],SMF_FILE[80],
           camdef[80],camoff[80],linfile[80],binning[10],answer[80],dfile[80],
           ifile[80],CHAR;
  char     *rind,*DATA_DIR;
  long     naxes[3],firstel,firste[2],nn;
  vect2    mpleft,mpright,vect;
  vect3    mskpos,ccdpos,campos;
  objq     *oq, *oq1;
  slit     slitdat;
  obsdef   obsdata;
  Obs     * obset = NULL;
  element  *instrument;
  FILE     *outfile,*infile,*linefile,*datfile;
  fitsfile *fptr[9];
  dewdat   dewinfo;
  fitsdef  fitsinfo;
  float     pi=3.1415926;

  float    dxmed,dymed,xmad,ymad,lcut,ceiling;
  int      l,loop,nread;
  float    *csort;

  edge=1.;
  nulvl=0;
  out=0;
  firstel=1;
  chipnum=0;
  //  flxrat=1.20; //required minimum ratio of max to min pixel for real aperture

  //data directory

  DATA_DIR=malloc(sizeof(CHAR)*80);
  DATA_DIR=getenv("COSMOS_IMAGE_DIR");
  if(DATA_DIR==NULL){
    printf("COSMOS_IMAGE_DIR undefined!\n");
    return 1;}
  strcat(DATA_DIR,"/");
  //printf("%s\n",DATA_DIR);


  //get parameters

  strcpy(file,"align-mask");
  if(OpenCosParm(file)!=0) die("Cannot open align-mask parameter file!");
  if(ReadParm_i("SEARCHBOX",&srchbox)==1) die("parameterfile error");
  if(ReadParm_i("MAGFACTOR",&magfac)==1) die("parameterfile error");
  if(ReadParm_s("LAMFILE",linfile)==1) die("parameterfile error");
  if(ReadParm_i("NAVER",&aver)==1) die("parameter file error");
  if(ReadParm_r("THRESHOLD",&flxrat)==1) die("parameter file error");
  if(ReadParm_r("SIGLIMIT",&lcut)==1) lcut=10;
  if(ReadParm_r("MAXFLUX",&ceiling)==1) ceiling=50000;
  if(ReadParm_r("WINDOWSIZE",&wid)==1) die("parameterfile error"); 

  /*------------------------get input data----------------------------------*/

  //prompt for data

  if(argc<5){
    while(1){
      printf("Enter observation name: ");
      scanf("%s",maskfile);
      if(ReadObsDef(maskfile,&obsdata)==0) break;
      printf("Error reading observation definition file %s!\n",maskfile);}
    printf("Enter mask image file name:   ");
    scanf("%s",dfile);}

  //data on command line

  else{
    if(!(strcmp(argv[1],"-o"))){
      narg=2;}
    else{
      if(!(strcmp(argv[3],"-o"))){
	narg=4;}
      else{
	printf("proper invocation: align-mask -o obserset -f imagefile\n");
	return 1;}
    }
    strcpy(maskfile,argv[narg]);
    if(ReadObsDef(maskfile,&obsdata)!=0){
      printf("Error reading observation definition file %s!\n",maskfile);
      return 1;}
    if(!(strcmp(argv[1],"-f"))){
      narg=2;}
    else{
      if(!(strcmp(argv[3],"-f"))){
	narg=4;}
      else{
	printf("proper invocation: align-mask -o obserset -f imagefile\n");
	return 1;}
      }
    strcpy(dfile,argv[narg]);
    if(argc>=6){
      if(!(strcmp(argv[5],"-c"))){
	sscanf(argv[6],"%d",&chipnum);}
      if(!(strcmp(argv[5],"-p"))){
	datfile=fopen("align-dewar.dat","w");
	out=1;}
      }
    }

  //get observing setup

  //mask data
  strcpy(flnm,obsdata.mask);
  strcat(flnm,".SMF");
  if(ReadSMFfile(flnm,&obset)) return 1;

  //Instrument setup
  SetupInstr(&obsdata,&instrument);
  if(SetupCamera(obsdata)==1) return 1;
  //chip data
  Getchipdat(&dewinfo);
  
  /********************* get data file info **********************************/

  strcpy(ifile,DATA_DIR);
  strcat(ifile,dfile);
  here=1;
  nchip=dewinfo.nchip;
  nread=0;
  for(i=1;i<=nchip;i++){
    strcpy(file,ifile);
    //addbar(file);
    //printf("%s\n",file);
    if(nchip==1){
      strcat(file,".fits");}
    else{
      strcat(file,"c");
      sprintf(line,"%d.fits",i);
      strcat(file,line);}
    //printf("\rReading %s",file);
    status=OpenFitsFile(file,&fptr[i],&fitsinfo);
    //if(status==204) fits_die("Error opening data file" ,status);
    if(status==104){printf("Could not read file %s\n" ,file);}
    nread++;}
  if(nread==0) fits_die("Error opening data file" ,status);
  bitpix=fitsinfo.bitpix;
  naxes[0]=fitsinfo.naxes[0];
  naxes[1]=fitsinfo.naxes[1];
  ibin=fitsinfo.binning;
  ybin=fitsinfo.ybinning;
  if(!ybin) ybin=ibin;
  nelem=naxes[0]*naxes[1];
  image=malloc(sizeof(INT)*nelem);
  array=malloc(sizeof(INTP)*naxes[1]);
  for(j=0;j<naxes[1];j++) *(array+j)=image+naxes[0]*j;
 
  //Additional info

  cur_temp=obset->temp;
  lines[0]=obset->cw;
  nlines=1;
  isspec=0;
  if(!strcmp(obsdata.mode,"SPEC")){
    isspec=1;
    //read spectral line file
    linefile=fopen(linfile,"r");
    if(linefile==NULL) die("Cannot open line file");
    nlines=0;
    while(nlines<100){
      if(nlines==4){
        printf("\a\nWarning: You have more than 3 lines in your ");
        printf("line list file, which may produce confusion ");
        printf("in align-mask!\n");}
      if(fgets(line,133,linefile)==NULL) break;
      sscanf(line,"%f",&lines[nlines]);
      nlines++;}
    }

  //find positions of all slits

  for(i=1;i<=nchip;i++) nob[i]=0;
  nobj=0;
  sigma=0.;
  oq=obset->ob;
  oq1=oq;
  while(1){
    if(oq==NULL) die("SMF file error");
    slitdat=oq->slit;
    for(i=0;i<nlines;i++){
      cur_wavl=lamb=lines[i];
      //fudge
//	cur_wavl=cur_wavl-0.003*(cur_wavl-7000.);
	//fudge
      while(1){
	//center
	mskpos = get3de2v(oq->smpos,0.0);
	ccdpos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
	xfp=ccdpos.x;
	yfp=ccdpos.y;
	chip=fp2ccd(xfp,yfp,&xccd,&yccd,cur_wavl);
	//is image on a chip?
	if(chip<1) break;
	//just use one chip?
	if(chipnum && chip != chipnum) break;
	//width
	vect.x=slitdat.width;
	vect.y=0.;
	mpleft=sum2vect(oq->smpos,vect);
	mskpos = get3de2v(mpleft,0.0);
	campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
	xlfp=campos.x;
	ylfp=campos.y;
	chip1=fp2ccd(xlfp,ylfp,&xlcd,&ylcd,cur_wavl);
	if(chip!=chip1)break;
	apwidth[nobj]=(sqrt((xlcd-xccd)*(xlcd-xccd)/(ibin*ibin)+(ylcd-yccd)*(ylcd-
                 yccd)/(ybin*ybin)));
	if(apwidth[nobj]<1.) apwidth[nobj]=1.;
	//"left"=minvalue slit end
	mpleft=sum2vect(oq->smpos,lslit(oq->slit));
	mskpos = get3de2v(mpleft,0.0);
	campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
	xlfp=campos.x;
	ylfp=campos.y;
	chip1=fp2ccd(xlfp,ylfp,&xlcd,&ylcd,cur_wavl);
	//is left end on same chip?
	if(chip!=chip1)break;
	xl[nobj]=xlcd/ibin;
	yl[nobj]=ylcd/ybin;
	//"right"=maxvalue slit end
	mpright=sum2vect(oq->smpos,rslit(oq->slit));
	mskpos = get3de2v(mpright,0.0);
	campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
	xfp=campos.x;
	yfp=campos.y;
	chip1=fp2ccd(xfp,yfp,&xcd,&ycd,cur_wavl);
	//is right end on same chip?
	if(chip !=chip1) break;
	xr[nobj]=xcd/ibin;
	yr[nobj]=ycd/ybin;
	aptype[nobj]=slitdat.shape;
	indx[nob[chip]][chip]=nobj;
	nob[chip]++;
	nobj++;
	if(nobj>=5000)printf("hit limit of aperture images\n");
	break;}
      if(nobj>=5000) break;}
    if(nobj>=5000) break;
    oq=oq->next;
    if(oq==oq1) break;}
  ntot=0;
  mxx=mxy=-100000.;
  mnx=mny=100000.;

  //for each chip, locate each slit image

  //read in image

  for(chip=1;chip<=nchip;chip++){
    printf("Analysing chip %d\r",chip);
    fflush(stdout);
    if(nob[chip]==0) continue;
    status=0;
    status=ReadFitsFile(&fptr[chip],&fitsinfo,TINT,image);
    if(status) fits_die("Error reading data file",status);
    for(n=0;n<nob[chip];n++){
      ind=indx[n][chip];

      //extraction box centered on aperture
    
      //if hole
      if(aptype[ind] != 2){
	//	if(isspec) continue;
	xmid=(xr[ind]+xl[ind])/2.;
	ymid=(yr[ind]+yl[ind])/2.;
       	halfht=halfwd=(int)(apwidth[ind]+0.5);
	boxwdth=boxht=2*halfht+1;
	sbox=malloc(sizeof(INT)*boxwdth*boxwdth);
	row=malloc(sizeof(INTP)*boxwdth);
	for(i=0;i<boxht;i++){
	  row[i]=sbox+i*boxwdth;
	  for(j=0;j<boxwdth;j++){
   	      *(row[i]+j)=1;}
	  }
        }
	         
      //if slit
      else{
	bx=dx=(xr[ind]-xl[ind])/2.;
	xmid=(xr[ind]+xl[ind])/2.;
	if(bx<0) bx=-bx;
	boxwdth=2*((int)(bx)+edge);
	by=dy=(yr[ind]-yl[ind])/2.;
	ymid=(yr[ind]+yl[ind])/2.;
	if(by<0) by=-by;
	boxht=2*((int)(by)+edge);
	/*	if(bx>by){
	  a2=boxwdth;
	  a3=dx;
	  boxwdth=boxht;
	  dx=dy;
	  boxht=a2;
	  dy=a3;}*/
	slope=dx/dy;
	halfwd=boxwdth/2;
	halfht=boxht/2;
	sbox=malloc(sizeof(INT)*boxwdth*boxht);
	row=malloc(sizeof(INTP)*boxht);
	for(i=0;i<boxht;i++){
	  row[i]=sbox+i*boxwdth;
	  xcen=halfwd+(i-halfht)*slope;
	  for(j=0;j<boxwdth;j++){
	    dj=j-xcen;
	    if(dj<0)dj=-dj;
	    if(dj<halfwd){
	      *(row[i]+j)=1;}
	    else{
	      *(row[i]+j)=0;}
	    }
	  }
      }

      //peak up on aperture
      
      sumax=0.;
      flmn=999999999.;
      flmx=0.;
      bflag=0;
      for(i=-srchbox;i<=srchbox;i++){
	xcorn=floor(xmid-halfwd)+i;
	for(j=-srchbox;j<=srchbox;j++){
	  ycorn=floor(ymid-halfht)+j;
	  sum=0.;
	  //sum over offset extraction box
	  for(jj=0;jj<boxht;jj++){
	    iyp=ycorn+jj;
	    if(iyp<0 || iyp>=naxes[1]){
	      bflag=1;
	      break;}
	    for(ii=0;ii<boxwdth;ii++){
	      ixp=xcorn+ii;
	      if(ixp<0 || ixp>=naxes[0]){
		bflag=1;
		break;}
	      flx= *(array[iyp]+ixp);
	      if(flx<flmn) flmn=flx;
	      if(flx>flmx)flmx=flx;
	      sum+=flx*(*(row[jj]+ii));
	      if(flx>flmx)flmx=flx;
              if(flx<flmn)flmn=flx;}
	    if(bflag) break;}
	  if(bflag) continue;
	  if(sum>sumax){
	    sumax=sum;
	    ixtop=i;
	    iytop=j;}
	  }
        }
      if(flmn<0) flmn=1;
      //     printf("%d %d %f %f %f %f\n" ,chip,n,xr[ind],yr[ind],flmx,flmn);


      // Would it be useful to have a maximum flux (i.e. oversaturated line)?
      // 65535
      if(flmx/flmn<flxrat || flmx > ceiling){
      //if(flmx/flmn<flxrat) {
        if(out) fprintf(datfile,"missed image at %d %f %f\n",chip,xmid,ymid);
        continue;}


      //printf("flmx = %f\n",flmx);
      //Take center of gravity within (enlarged) aperture

      sumx=0;
      sumy=0;
      sum=0;
      bflag=0;
      xcorn=floor(xmid-halfwd+ixtop);
      ycorn=floor(ymid-halfht+iytop);
      for(jj=-3;jj<boxht+3;jj++){
	iyp=ycorn+jj;
	if(iyp<0 || iyp>=naxes[1]){
	  bflag=1;
	  break;}
	for(ii=-3;ii<boxwdth+3;ii++){
	  ixp=xcorn+ii;
	  if(ixp<0 || ixp>=naxes[0]){
	    bflag=1;
	    break;}
	  flx= *(array[iyp]+ixp);
	  sumx+=flx*ixp;
	  sumy+=flx*iyp;
	  sum+=flx;}
        if(bflag) break;}
      if(bflag) continue;
      xnew=sumx/sum;
      ynew=sumy/sum;

      xmid*=ibin;
      ymid*=ybin;
      xnew*=ibin;
      ynew*=ybin;
      ccd8(chip,xnew,ynew,&x8,&y8);
      ccd8(chip,xmid,ymid,&xm8,&ym8);
      x[ntot]=xm8;
      y[ntot]=ym8;
      xs[ntot]=x8;
      ys[ntot]=y8;
      xd[ntot]=x8-xm8;
      yd[ntot]=y8-ym8;
      chp[ntot]=chip;

      // fix for lack of clipping issue (4-30-08)
      sigma1=((x8-xm8)*(x8-xm8)+(y8-ym8)*(y8-ym8));
      //printf("sigma1 = %f\n\n",sigma1);
//      if(sqrt(sigma1) > srchbox ) {
//        continue;
//      }
  
      //printf("x8, xm8, y8 ym8 = %f, %f, %f, %f\n",x8,xm8,y8,ym8);
      //printf("sigma1 = %f\n",sigma1);
      //printf("est_sigma = %f\n",sqrt(sigma1));
      //sigma+=((x8-xm8)*(x8-xm8)+(y8-ym8)*(y8-ym8));
      sigma+=sigma1;
      //printf("sigma = %f\n\n",sigma);

      if(mnx>x8)mnx=x8;
      if(mny>y8)mny=y8;
      if(mxx<x8)mxx=x8;
      if(mxy<y8)mxy=y8;
      mspos(chip,xnew,ynew,&x8,&y8);
      if(out) fprintf(datfile,"%d %6.1f %6.1f %6.1f %6.1f %6.1f %6.1f %6.1f %6.1f\n",
                      chip,xmid,ymid,xnew,ynew,x8,y8,xd[ntot],yd[ntot]);
      ntot++;
      if(ntot>=5000) break;
      free(row);
      free(sbox);}
    if(ntot>=5000) break;}


      //lcut = 10.0;
      for(loop=0;loop<3;loop++) {
         csort = (float *) malloc(ntot*sizeof(float));

         for(k=0;k<ntot;k++) csort[k]=xd[k];
         qsort(csort, ntot, sizeof(float), (void *)comp_nums);
         dxmed = csort[ntot/2];

         for(k=0;k<ntot;k++) csort[k]=yd[k];
         qsort(csort, ntot, sizeof(float), (void *)comp_nums);
         dymed = csort[ntot/2];

         for(k=0;k<ntot;k++) csort[k]=fabs(xd[k]-dxmed);
         qsort(csort, ntot, sizeof(float), (void *)comp_nums);
         xmad = 1.49*csort[ntot/2];

         for(k=0;k<ntot;k++) csort[k]=fabs(yd[k]-dymed);
         qsort(csort, ntot, sizeof(float), (void *)comp_nums);
         ymad = 1.49*csort[ntot/2];

         printf("Delta=(%.2f %.2f) Sigma=(%.2f %.2f)\n", dxmed,dymed,xmad,ymad);
         xmad = (xmad > 1) ? xmad : 1.0;
         ymad = (ymad > 1) ? ymad : 1.0;

         free(csort);

         if (1) {
         for(k=0;k<ntot;k++) {
          if ((fabs(yd[k]-dymed) > lcut*ymad) || (fabs(xd[k]-dxmed) > lcut*xmad)) {
            printf("Clipping out (%.2f,%.2f)\n",x[k],y[k]);
            for(l=k;l<ntot-1;l++) {
              x[l] = x[l+1];
              y[l] = y[l+1];
              xs[l] = xs[l+1];
              ys[l] = ys[l+1];
              xd[l] = xd[l+1];
              yd[l] = yd[l+1];
              chp[l] = chp[l+1];
            }
            ntot = ntot-1;
            k -= 1;
          }
         }
         }
         //lcut = 5.0;
         lcut /= 1.25;
      }

      sigma = 0.0;
      for(k=0;k<ntot;k++) {
         sigma1=xd[k]*xd[k]+yd[k]*yd[k];
         sigma+=sigma1;
      }


  /*   PLOT RESIDUALS                                                      */

  if(ntot<2) die("\ninsufficient matches to do a fit\n");
  ddx=mxx-mnx;
  if(mxy-mny > ddx) ddx=mxy-mny;
  mxx+=0.1*ddx;
  mnx-=0.1*ddx;
  mxy+=0.1*ddx;
  mny-=0.1*ddx;
  aspct=(mxy-mny)/(mxx-mnx);
  cpgopen("/xwindow");
  //wid=9.0;
  if(!wid){wid=5.0;}
  if(aspct*wid>10.){wid=10./aspct;}
//  printf("\n wid,aspct: %.2f,%.2f",wid,aspct);
  cpgpap(wid,aspct);
  cpgpage; 
  cpgsch(1);
  cpgscr(0,1,1,1);
  cpgscr(1,0,0,0);
  cpgask(0);
  cpgsci(1);
  cpgenv(mnx,mxx,mny,mxy,0,0);
  cpglab("X","Y",maskfile);
  cpgsch(1);
  cpgslw(3);
  cpgpt(ntot,x,y,-1);
  for(i=0;i<ntot;i++){
    cpgslw(10);
    cpgpt(1,x+i,y+i,-1);
    cpgslw(1);
    xa[0]=x[i];
    ya[0]=y[i];
    if(aver>1){
      for(j=0;j<ntot;j++){
	sc=pow(x[i]-x[j],2)+pow(y[i]-y[j],2);
	order(&j,&sc,irnk,rank);}
      sc2=sc=0;
      for(j=0;j<aver;j++){
	sc2+=xd[irnk[j]];
	sc+=yd[irnk[j]];}
      xdd=sc2/aver;
      ydd=sc/aver;}
    else{
      xdd=xd[i];
      ydd=yd[i];}
    xa[1]=x[i]+magfac*xdd;
    ya[1]=y[i]+magfac*ydd;
    cpgline(2,xa,ya);}
    

  /*   CALCULATE RELATIVE SCALES                                           */

  sigma=sqrt(sigma/ntot);
  printf("\n\n%d matches found. sigma= %6.2f pixels  Continue? ",ntot,sigma);
  fgets(answer,80,stdin);
  if(!strncasecmp(answer,"n",1)) return 0;

  divid2=ceil(ntot*0.02);
  if(divid2<1) divid2=1;
  n_pairs=0;
  for(i=0;i<ntot;i+=divid2){
    for(j=i+1;j<ntot;j+=divid2){
      sc2=(pow(x[i]-x[j],2.)+pow(y[i]-y[j],2.))/
	(pow(xs[i]-xs[j],2.)+pow(ys[i]-ys[j],2.));
      sc=sqrt(sc2);
      order(&n_pairs,&sc,irnk,rank);
      n_pairs++;}
    }
  //take average of central 60% of values
  np1=0.2*n_pairs;
  np2=0.8*n_pairs;
  scale=0.;
  for(i=np1;i<np2;i++) scale+=rank[i];
  scale/=(np2-np1);
  printf("\nAverage scale =          %7.5f    Reset scale? ",scale);
  fflush(stdout);
  fgets(answer,80,stdin);
  if(!strncasecmp(answer,"n",1)) scale=1;
  if(!strncasecmp(answer,"q",1)) return 0;

  /*    RESCALE, FIND CENTROIDS                                              */

  xavv=yavv=0.;
  for(i=0;i<ntot;i++){
    x[i]/=scale;
    xs[i]/=scale;
    xavv+=x[i];
    y[i]/=scale;
    ys[i]/=scale;
    yavv+=y[i];}
  xavv/=ntot;
  yavv/=ntot;

  /*      CALCULATE ROTATION ANGLE                                           */

  thetav=0;
  tlist=malloc(sizeof(thetas)*ntot*ntot/2+1);
  npr=0;
  for(i=0;i<ntot;i+=divid2){
    x2=x[i];
    y2=y[i];
    xs2=xs[i];
    ys2=ys[i];
    for(j=i+1;j<ntot;j+=divid2){
      x1=x2-x[j];
      y1=y2-y[j];
      xs1=xs2-xs[j];
      ys1=ys2-ys[j];
      r_1=sqrt(x1*x1+y1*y1);
      theta=acos((double)x1/r_1);
      if(y1<0) theta=-theta;
      rs_1=sqrt(xs1*xs1+ys1*ys1);
      thetas=acos((double)xs1/rs_1);
      if(ys1<0) thetas=-thetas;
      thetas-=theta;
      if(thetas>pi) thetas-=2.*pi;
      if(thetas<-pi) thetas+=2.*pi;
      *(tlist+npr)=thetas;
      rank[npr]=r_1;
      npr++;}
    }

  /*check for angles straddling 180 degrees*/
   
  nneg=npos=avneg=avpos=0;
  for(i=0;i<npr;i++){
    if(*(tlist+i)<0){
      nneg++;
      avneg+=*(tlist+i);}
    else{
      npos++;
      avpos+=*(tlist+i);}
    }
  if(npos>0 && nneg>0){
    avneg/=nneg;
    avpos/=npos;
    if(avneg<-pi/2. && avpos>pi/2.){
      for(i=0;i<npr;i++){
	if(*(tlist+i)<0) *(tlist+i)+=2.*pi;}
     }
   }
   
  dtheta=0;
  thetas=0;
  for(i=0;i<npr;i++){
   thetas+=*(tlist+i)*rank[i];
    dtheta+=rank[i];}
  thetav=thetas/dtheta;
  dtheta=thetav*57.2958;
  free(tlist);
  printf("\nAverage rotation angle = %7.3f    Reset angle? ",dtheta);
  fflush(stdout);
  fflush(stdin);
  fgets(answer,80,stdin);
  if(!strncasecmp(answer,"q",1)) return 0;
  if(!strncasecmp(answer,"n",1)) thetav=0.;
  
  /*   ROTATE                                                                */
  
  else{
    xv=xavv;
    yv=yavv;
    for(i=0;i<ntot;i++){
      x1=x[i]-xv;
      y1=y[i]-yv;
      r_1=sqrt(x1*x1+y1*y1);
      theta=acos((double)x1/r_1);
      if(y1<0) theta=-theta;
      theta-=thetav;
      x[i]=r_1*cos(theta)+xv;
      y[i]=r_1*sin(theta)+yv;}
    }

  /*   CALCULATE X,Y OFFSETS                                                 */

  
  deltax=0;
  deltay=0;
  n_pairs=0;
  for(i=0;i<ntot;i++){
    xxx=x[i]-xs[i];
    yyy=y[i]-ys[i];
    order(&n_pairs,&xxx,irnk,rank);
    order(&n_pairs,&yyy,irnk_y,rank_y);
    n_pairs++;}
  np1=0.2*n_pairs;
  np2=0.8*n_pairs;
  deltax=deltay=0.;
  for(i=np1;i<np2;i++){
    deltax+=rank[i];
    deltay+=rank_y[i];}
  deltax=-deltax/(np2-np1);
  deltay=-deltay/(np2-np1);
  printf("\nAverage X,Y Offsets =  %6.1f %6.1f pixels. Apply shifts? ",deltax,deltay);
  fflush(stdout);
  deltax/=dewinfo.scale;
  deltay/=dewinfo.scale;
  fflush(stdin);
  fgets(answer,80,stdin);
  if(!strncasecmp(answer,"n",1)){
    deltax=0.;
    deltay=0.;}
  if(!strncasecmp(answer,"q",1)) return 0;
  if(deltax==0. && deltay==0. && thetav==0. && scale==1.) return 0;

  /* CORRECT COF FILE AND REWRITE                                            */

  strcpy(file,obsdata.dewoff);
  strcat(file,".dewoff");
  infile=fopen(file,"r");
  if(infile==NULL){
    printf("Cannot open dewar offset file %s\n",file);
    return(1);}

  //if image file and dewoff file have same name, create backup copy

  //remove leading directories
  rind=rindex(dfile,'/');
  if(rind==NULL) rind=&dfile[0]-1;
  rind+=1;
  strcpy(dfile,rind);
  if(!(strcmp(obsdata.dewoff,dfile))){
    strcat(file,"%");
    outfile=fopen(file,"w");
    while(1){
      if(!fgets(line,133,infile)) break;
      fprintf(outfile,"%s",line);}
    fclose(outfile);
    fclose(infile);
    infile=fopen(file,"r");}

  strcpy(file,dfile);
  strcat(file,".dewoff");
  outfile=fopen(file,"w");
  if(outfile==NULL){
    printf("Unable to create new dewar offset file %s\n",file);
    return 1;}
  printf("Creating new dewar offset file %s\n",file);
  while(1){
    if(!fgets(line,133,infile)){
      fclose(infile);
      printf("Error reading coff file\n");
      return 1;}
    if(*line=='#'){
      fprintf(outfile,"%s",line);
      continue;}
    sscanf(line,"%f %f %f %f %d",&theta,&scal,&xxx,&yyy,&ypar);
    theta-=57.2958*thetav;
    scal*=scale;
    xxx-=deltax;
    yyy-=deltay;
    fprintf(outfile,"%7.3f %7.5f %8.3f %8.3f %d\n",theta,scal,xxx,yyy,ypar);
    break;}
  fclose(infile);
  fclose(outfile);
  return  0;
}
  
int comp_nums(const float *num1, const float *num2)
{
   if (*num1 <  *num2) return -1;
   if (*num1 == *num2) return  0;
   if (*num1 >  *num2) return  1;
}


