/*
*  EDITPAR reproduces the function of the IRAF routine EPARAM. Looks for  files
*         in (1) local directory and then (2) $COSMOS_HOME/uparm and then in
*         $COSMOS_HOME/sdata/uparm
*
*         USAGE: epar procedurename
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

main(int argc, char* argv[]){

  char      filename[81],oldfile[81],keyword[100][41],comment[100][41],
            filepath[81],cvalue[100][41],type,linetype[100],command[81],
            file[80],line[82],buf[80];
  char       CHAR,*Xflag, *Path,*PARMDIR;
  int        i,ivalue[100],npar,parnum;
  float      r,rvalue[100];
  FILE       *infile,*outfile;

    if(argc < 2){
        printf("Usage: editpar procedurename\n");
        return;}
    strcpy(filename,argv[1]);
    strcat(filename,".par");
    
    PARMDIR=malloc(80*sizeof(CHAR));
    PARMDIR=getenv("COSMOS_PAR_DIR");
    if(PARMDIR != NULL){
      strcpy(filepath,PARMDIR); 
      if(*(filepath+strlen(filepath)-1) != '/') strcat(filepath,"/");}
    else{
      printf("COSMOS_PAR_DIR not defined!\n");}
    strcat(filepath,filename);
    infile=fopen(filepath,"r");
    if(infile==NULL){
      printf("Unable to find %s\n",filepath);
      return 1;}

    strcpy(filename,filepath);
    strcpy(oldfile,filename);
    strcat(oldfile,"%");
    strcpy(command,"mv -f ");
    strcat(command,filename);
    strcat(command," ");
    strcat(command,oldfile);
    printf("%s\n",filepath);
    system(command);

    infile=fopen(oldfile,"r");
    outfile=fopen(filename,"w");
    if(infile==NULL || outfile==NULL){
        printf("Error opening parameter file %s\n",filename);
        return;}

    for(npar=0;1;npar++){
        if(fscanf(infile,"%[^,],%c",&keyword[npar][0],&linetype[npar])<2 ||
           !strcmp(keyword[npar],"mode")) break;
        switch(linetype[npar]){
            case 'r':
                     fscanf(infile,",h,%f",&rvalue[npar]);
                     break;
            case 'i':
                     fscanf(infile,",h,%i",&ivalue[npar]);
                     break;
            case 'f':
                     fscanf(infile,",h,\"%[^\"]\"",&cvalue[npar]);
                     break;
            case 's':
                     fscanf(infile,",h,\"%[^\"]\"",&cvalue[npar]);
                     break;
            case 'b':
                     fscanf(infile,",h,%[^,]",&cvalue[npar]);
                     break;}
        fscanf(infile,",,,\"%[^\"]\"\n",&comment[npar]);}

    for(;;){
     system("clear");
     printf("type q to end\n\n");
     for (i=0;i<npar;i++) {
        switch(linetype[i]){
            case 'r':
                     printf("%-15s     %10f       %s\n",keyword[i],rvalue[i],
                            comment[i]);
                     break;
            case 'i':
                     printf("%-15s     %10i       %s\n",keyword[i],ivalue[i],
                            comment[i]);
                     break;
            case 'b':
                     printf("%-15s     %+10s       %s\n",keyword[i],cvalue[i],
                     comment[i]);
                     break;
            case 'f':
                     printf("%-15s     %+10s       %s\n",keyword[i],cvalue[i],
                     comment[i]);
                     break;
            case 's':
                     printf("%-15s     %+10s       %s\n",keyword[i],cvalue[i],
                     comment[i]);
                     break;}
            }
        printf("\n\nChange parameter:   ");
        fflush(stdin);
        fflush(stdout);
        scanf("%s",buf);
        if(!strcmp(buf,"Q") || !strcmp(buf,"q")) break;
        parnum=-1;
        for(i=0;i<npar;i++){
            if(!strcasecmp(buf,keyword[i])){
            parnum=i;
            break;}
        }
        if(parnum <0){
        printf("\nNot a valid parameter\n");
        continue;}
        printf("Enter new value(s): ");
        fflush(stdout);
        fflush(stdin);
        switch(linetype[parnum]){
            case 'i':
                     scanf("%i",&ivalue[parnum]);
                     break;
            case 'r':
                     scanf("%f",&rvalue[parnum]);
                     break;
            case 'b':
                     scanf("%s",&cvalue[parnum]);
                     break;
            case 'f':
                     scanf("%s",&cvalue[parnum]);
                     break;
            case 's':
                     scanf("%s",&cvalue[parnum]);
                     break;}
        }

/*   rewrite the par file with revised parameters                            */

     for (i=0;i<npar;i++) {
        switch(linetype[i]){
            case 'r':
                     fprintf(outfile,"%s,r,h,%f,,,\"%s\"\n",keyword[i],
                            rvalue[i],comment[i]);
                     break;
            case 'i':
                    fprintf(outfile,"%s,i,h,%i,,,\"%s\"\n",keyword[i],ivalue[i],
                            comment[i]);
                     break;
            case 'f':
                     fprintf(outfile,"%s,f,h,\"%s\",,,\"%s\"\n",keyword[i],
                             cvalue[i],comment[i]);
		     break;
            case 's':
                     fprintf(outfile,"%s,s,h,\"%s\",,,\"%s\"\n",keyword[i],
                             cvalue[i],comment[i]);
		     break;
            case 'b':
                     fprintf(outfile,"%s,b,h,%s,,,\"%s\"\n",keyword[i],
                             cvalue[i],comment[i]);
                     break;}
            }
    fprintf(outfile,"mode,s,h,\"q1\",,,\n");
    fclose(infile);
    fclose(outfile);
    return;
}



