/*****************************************************************************\
*                                                                             *
*  EXTRACT extracts 1-d or 2-dspectra CR rejection is an option               *
*                                                                             *
*  VERSION  17 Apr 2004                                                       *
*                                                                             *
\*****************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "fitsio.h"
#include "cosmos.h"
#include "cpgplot.h"

int main(int argc,char *argv[]){

  char  file[80],flnm[80],ifile[80],dfile[80],*datadir,line[133],*lin,c[7],
        diag[7],jfile[80],ofile[80],answer[80],CHAR,*CHARP,*homedir,*ch,*name;
  int   INT,status,bitpix,naxis,nelem,i,j,here,xdisper,ord_disp,ord_sag,ntot,
        nolm,ord_tilt,ord_sagit,ord_slen,nslit,n_slit,n_slitpix,n_lampix,chip,
        slitnum,max_slit,n80,breakpoint,iii,ni,ixpos,iypos,lvmin,lvmax,dsign,
        end,ij,anynl,dimen,clean,proff,search,strsz,strip,b1,b2,uu,vv,splf,
        ychp,k,nuxes[2],iyp,ixp,iy,islff,nwval,nsval,isl,ssign;
  float FLOAT,delta_lambda,delta_slit,telscale,min_lambda,max_lambda,lambda0,
        axp,prmax,v1,lambda1,slen,slit_len,slmin,slmax,lmin,lmax,sloff,sldknot,
        ayp,wt,dltaslt,lv,lambda,xcen,ycen,slnt,scatl,slitend,slitpos,ypos,yp,
       xpos,wlcen,yval1,yvaln,wid,fmin,fmax,dix,diy,value,d11,d21,d12,d22,tilt;
  float coef_disp[20][10],coef_sag[20][10],coef_tilt[10],coef_sagit[10],
        coef_slen[10];
  long  newaxes[2],naxes[3],noxes[2],firstel,firstelem[3],stack_len,fpixel[2],
        flen,lpixel[2];
  int   *INTP,*good[20],*gd,**goodpix[20],*sltnum,*isloff;
  float *stdev,*FLOATP,**stack,**spectrum,*sm,**sumspc,*image[20],*im,*ones,
        *g,**goo,**array[20],*s_image[20],*s_im,**s_array[20];
  short int SHINT,*SHINTP,*wet[20],**weight[20];
  int   nulvl=0;
  int   one=1;
  fitsfile *fptr_obj[20][9],*fptr_sky[20][9],*outptr;
  fitsdef fitsinfo;

  int   is,ix,ixmx,iymx,ixx,iyy,nint,nexty,iytop,iybot,i1,i2,any,jj,ii,size,
        slit_order,nchp,nlv,nshuffle,skysub,nfile,srcsz,iycen,n200,n1,ibin,
        kwork,nknotwl,nknotsl,nestwl,nestsl,morder,nestm,bx,by,iopt,ier,brk,
        lwork1,lwork2,slorder,wlorder,filen,iwl,iwlmx,islmx,islcen,nax0,nax1,
        ixl,nsp,inshuffle;
  float resid,lval1,lvaln,flux,medval,thrsh,siglimit,noise,gain,xxx,
        wlv1,wlvn,slv1,slvn,sagt,sagsn,rag,disp,exptime[20],wldknot,slcen,llow,
        aa,bb,cc,dslt,dknots,dx,lala,lhigh,tthrsh,bthrsh;
  float *ytemp,coef_xdisp[20][10];
  float *sval,*wval,*flxval,*slval,*noefs,*nootl,*knotl,*lamval,*rnk,*lamtemp,
    *knotsl,*coefs,*work1,*ptl,*ptx,*nooty,*work2,*knotwl,*goodtemp,*gdpx,
    *twt,**twght;
  int   *noff,*iwork,*indx,*indy,*indf,*irnk,*prfl;
  double a1;
  int   optimal,nk1,narg;
  float smfac,delknotl,delknoty,ki,di;
  FILE  *mapfile[20],*datafile;

  lamval=slval=stdev=ones=flxval=NULL;
  spectrum=NULL;
  indx=indy=indf=NULL;
  firstelem[0]=firstelem[1]=firstelem[2]=1;
  firstel=1;
  nuxes[0]=nuxes[1]=1;
  g=calloc(4,sizeof(FLOAT));
  goo=calloc(2,sizeof(FLOATP));
  for(i=0;i<2;i++) *(goo+i)=g+2*i;
  //parameters
  breakpoint=0;
  smfac=0.;
  nulvl=0;
 
   //directories
  datadir=malloc(sizeof(CHAR)*80);
  datadir=getenv("COSMOS_IMAGE_DIR");
  if(datadir==NULL){
    printf("COSMOS_IMAGE_DIR undefined!\n");
    return 1;}
  strcat(datadir,"/");
  homedir=malloc(sizeof(CHAR)*80);
  homedir=getenv("COSMOS_HOME");
  if(homedir==NULL){
    printf("COSMOS_HOME undefined!\n");
    return 1;}
  strcat(homedir,"/");

  //get parameters
  optimal=clean=0;
  if(OpenCosParm("extract")!=0) die("Cannot open parameter file");
  if(ReadParm_r("minlambda",&min_lambda)==1)die("parameter file error");
  if(ReadParm_r("maxlambda",&max_lambda)==1)die("parameter file error");
  if(ReadParm_r("deltalam",&delta_lambda)==1)die("parameter file error");
  if(ReadParm_i("dimension",&dimen)==1)die("parameter file error");
  if(ReadParm_b("clean",&clean)==1) die("parameter file error");
  if(ReadParm_i("search",&search)==1) die("parameter file error");
  if(ReadParm_i("slit_order",&slorder)==1) die("parameter file error");
  if(ReadParm_i("lambda_order",&wlorder)==1) die("parameter file error");
  if(ReadParm_r("slit_knot",&sldknot)==1)die("parameter file error");
  if(ReadParm_r("lambda_knot",&wldknot)==1)die("parameter file error");
  strip=optimal=0;
  if(dimen==1){
    if(ReadParm_b("optimal",&optimal)==1) die("parameter file error");}
  else{
    if(ReadParm_r("deltaslit",&delta_slit)==1) die("parameter file error");}
  if(ReadParm_i("strip",&strip)==1) die("parameter file error");
  strsz=2*strip+1;
  if(search>0){
    srcsz=2*search+1;
    prfl=malloc(srcsz*sizeof(INT));}
  if(clean || optimal){
    if(ReadParm_r("siglimit",&siglimit)==1)die("parameter file error");
    if(ReadParm_r("noise",&noise)==1)die("parameter file error");
    if(ReadParm_r("gain",&gain)==1)die("parameter file error");}
  if(ReadParm_s("diag",diag)==1) die("parameter file error");
  if(diag[0]=='s' || diag[0]=='S'){
    diag[0]='s';
    nwval=1;
    nsval=101;
    sval=calloc(101,sizeof(FLOAT));
    wval=calloc(1,sizeof(FLOAT));
    for(i=0;i<101;i++) *(sval+i)=i-50;}
  else{
    if(diag[0]=='l' || diag[0]=='L'){
      diag[0]='l';
      nsval=1;
      nwval=101;
      wval=calloc(101,sizeof(FLOAT));
      sval=calloc(2,sizeof(FLOAT));
      *sval=0;
      for(i=0;i<101;i++) *(wval+i)=5527.+i;}
    else{
      diag[0]='n';}
    }

 //get input files
  skysub=0;
  nfile=0;
  while(1){
  X:   printf("Enter map & image file names CR=>end:   ");
    fgets(line,133,stdin);
    if(strlen(line)<2) break;
    sscanf(line,"%s %s",dfile,file);
    if(strstr(dfile,".map")==NULL)strcat(dfile,".map");
    mapfile[nfile]=fopen(dfile,"r");
    if(mapfile[nfile]==NULL){
      printf("mapfile %s does not exist!\n",dfile);
      goto X;}
    strcpy(flnm,datadir);
    strcat(flnm,file);
    ch=strstr(flnm,"_s");
    //is frame sky-subtracted?
    if(ch!=NULL){
      if(!nfile){
	skysub=1;}
      else{
	if(!skysub)die("Inconsistent sky subtraction");}
      //open unsubtracted frame if CR cleaning
      if(clean || optimal){
	i=ch-flnm;
	strncpy(ifile,flnm,i);
	memcpy(&ifile[i],"\0",1);
	strcat(ifile,"_f");
	for(j=1;j<=8;j++){
	  strcpy(jfile,ifile);
	  addbar(jfile);
	  strcat(jfile,"c");
	  sprintf(c,"%d.fits",j);
	  strcat(jfile,c);
	  status=0;
	  status=OpenFitsFile(jfile,&fptr_sky[nfile][j],&fitsinfo);
	  if(status){
	    printf("sky file %s cannot be found\n",jfile);
	    goto X;}
	  }
	}
      }
    //open data file
    addbar(flnm);
    for(j=1;j<=8;j++){
      strcpy(jfile,flnm);
      strcat(jfile,"c");
      sprintf(c,"%d.fits",j);
      strcat(jfile,c);
      status=0;
      status=OpenFitsFile(jfile,&fptr_obj[nfile][j],&fitsinfo);
      if(status){
	printf("data file %s cannot be found!\n",jfile);
	goto X;}
    }      
    exptime[nfile]=fitsinfo.exptime;
    if(clean && exptime[nfile]==0){
      printf("Enter exposure time for this file: ");
      fgets(line,133,stdin);
      sscanf(line,"%f",&exptime[nfile]);}
    nfile++;
    if(nfile>=20) break;}
  if(nfile>1){
    printf("Enter output file name: ");
    scanf("%s",ofile);}
  else{
    clean=0;
    strcpy(ofile,file);}
  if(!clean && !optimal)skysub=0;
  naxes[0]=fitsinfo.naxes[0];
  naxes[1]=fitsinfo.naxes[1];
  ibin=fitsinfo.binning;
  nelem=naxes[0]*naxes[1];
  nshuffle=fitsinfo.nshuffle;
  twt=calloc(nelem,sizeof(FLOAT));
  twght=calloc(naxes[1],sizeof(FLOATP));
  for(k=0;k<naxes[1];k++) *(twght+k)=twt+k*naxes[0];
  for(k=0;k<nfile;k++){
    wet[k]=calloc(nelem,sizeof(SHINT));
    weight[k]=calloc(naxes[1],sizeof(SHINTP));
    for(i=0;i<naxes[1];i++){
      *(weight[k]+i)=wet[k]+i*naxes[0];
      for(j=0;j<naxes[0];j++) *(*(weight[k]+i)+j)=1.;}
    }
  aa=0;
  if(clean){
    for(i=0;i<nfile;i++) aa+=exptime[i];
    for(i=0;i<nfile;i++) exptime[i]/= aa/nfile;}

  //input buffers
  for(i=0;i<nfile;i++){
    image[i]=calloc(nelem,sizeof(FLOAT));
    array[i]=malloc(sizeof(FLOATP)*naxes[1]);
    for(j=0;j<naxes[1];j++) *(array[i]+j)=image[i]+j*naxes[0];
    if(clean || optimal){
      s_image[i]=calloc(nelem,sizeof(FLOAT));
      s_array[i]=malloc(sizeof(FLOATP)*naxes[1]);
      for(j=0;j<naxes[1];j++) *(s_array[i]+j)=s_image[i]+j*naxes[0];}
    }

  //Read mapping data
  fgets(line,133,mapfile[0]);
  if(!sscanf(line,"Xdispersion = %d",&xdisper)){
    printf("Mapfile error\n");
    return 1;}
  fgets(line,133,mapfile[0]);
  if(!sscanf(line,"Fit orders = %d %d %d %d %d",&ord_disp,&ord_sag,&ord_tilt,
	     &ord_sagit,&ord_slen)){
    printf("Mapfile error\n");
    return 1;}
  if(ord_disp>9 || ord_sag>9 || ord_tilt>9 || ord_sagit>9 || ord_slen>9){
    printf("Warning: maximum fit order = 9\n");
    return 1;}
  fgets(line,133,mapfile[0]);
  if(!sscanf(line,"Scale ~ %f",&telscale)){
    printf("Mapfile error\n");
    return 1;}
  if(dimen==2) delta_slit=delta_slit/telscale;
  fgets(line,133,mapfile[0]);
  if(!sscanf(line,"Lambda = %f %f",&lambda0,&lambda1)){
    printf("Mapfile error\n");
    return 1;}
  if(lambda0>min_lambda){
    printf("Warning: minimum lambda set to %f\n",lambda0);
    min_lambda=lambda0;}
  if(lambda1<max_lambda){
    printf("Warning: maximum lambda set to %f\n",lambda1);
    max_lambda=lambda1;}
  fgets(line,133,mapfile[0]);
  xxx=0.;
  max_slit=0;
  n_slit=0;
  n_lampix=(max_lambda-min_lambda)/delta_lambda+2;
  //find #of mapped slits, width of widest
  while((fgets(line,133,mapfile[0]))!=NULL){
    if(!sscanf(line,"LENGTH = %f",&slen)) continue;
    n_slit++;
    if(slen>xxx) xxx=slen;}
  max_slit=1+(int)(xxx/delta_slit);
  rewind(mapfile[0]);

  stack_len=n_lampix*max_slit;
  isloff=malloc(n_slit*sizeof(INT));
  noff=calloc(n_slit,sizeof(INT));
  sltnum=malloc(n_slit*sizeof(INT));
  n80=80*n_slit;
  name=malloc(n80*sizeof(CHAR));
  ixmx=naxes[0];
  iymx=naxes[1];
  if(!xdisper){
    ixmx=iymx;
    iymx=naxes[0];}
  
  //output image file
  if(diag[0]=='n'){
    strcpy(ifile,"!");
    strcat(ifile,datadir);
    strcat(ifile,ofile);
    addbar(ifile);
    subbars(ifile);
    if(dimen==1){
      strcat(ifile,"_1spec.fits");}
    else{
      strcat(ifile,"_2spec.fits");}
    status=0;
    fits_create_file(&outptr,ifile,&status);
    if(status){
      printf("Unable to create output spectrum file (%d)\n",status);
      return 1;}
    }
  //output buffers for each spectrum
  stack=malloc(n_slit*sizeof(FLOATP));
  for(i=0;i<n_slit;i++){
    if(dimen==1){
      *(stack+i)=calloc(n_lampix,sizeof(FLOAT));
      continue;}
    else{
      *(stack+i)=calloc(stack_len,sizeof(FLOAT));}
    }

  //diagnostics
  if(diag[0]!='n'){
    cpgopen("/xwindow");
    wid=6.;
    cpgpap(wid,1.);}
  /*------------Extract Spectra, one chip at a time--------------------------*/
  
  for(nchp=1;nchp<=8;nchp++){
    nslit=-1;

    for(filen=0;filen<nfile;filen++){
      //read in chip data
      status=0;
      fits_read_img(fptr_obj[filen][nchp],TFLOAT,firstel,nelem,&nulvl,
                    image[filen],&anynl,&status);
      if(status) fits_die("spectral file error",status);
       if((optimal || clean) && diag[0]=='n'){
	fits_read_img(fptr_sky[filen][nchp],TFLOAT,firstel,nelem,&nulvl,
                      s_image[filen],&anynl,&status);}
      if(status) fits_die("sky file error",status);
      rewind(mapfile[filen]);}
    end=0;

    //each file, each slit
    while(11){
      ychp=0;
      for(filen=0;filen<nfile;filen++){
  A:    if((fgets(line,133,mapfile[filen]))==NULL) 
                                              die("Unexpected end to mapfile");
  B:    if(!strncmp(line,"END",3)) goto END;
        if(strstr(line,"SLIT")==NULL) goto A;                                  
	//found a slit 
	sscanf(line,"SLIT %d %s",&slitnum, name+80*(nslit+1));
	printf("Processing Chip %d Slit %3d\r",nchp,slitnum);
	fflush(stdout);
	if((fgets(line,133,mapfile[filen]))==NULL) 
                                             die("Unexpected end of  mapfile");
	if(!sscanf(line,"LENGTH = %f",&slit_len)) goto B;              
	//slit with data
	sltnum[nslit+1]=slitnum;
	if(!filen){
	  nslit++;
	  nint=0;
	  if(dimen==2){
	    n_slitpix=slit_len/delta_slit;
	    spectrum=realloc(spectrum,sizeof(FLOATP)*n_slitpix);
	    for(i=0;i<n_slitpix;i++) *(spectrum+i)=*(stack+nslit)+i*n_lampix;}
	  else{
	    spectrum=realloc(spectrum,sizeof(FLOATP));
	    *spectrum=*(stack+nslit);}
	}

	//New Chip
  C:	if((fgets(line,133,mapfile[filen]))==NULL) 
                                              die("Unexpected end of mapfile");
	if(!strncmp(line,"END",3)) goto END;  
	
	if(!sscanf(line,"CHIP %d",&chip)){
	  //end of slit
	  i=-strlen(line);
	  fseek(mapfile[filen],i,SEEK_CUR);
	  continue;}
	if(chip != nchp){
	  //wrong chip
	  for(i=0;i<6;i++){
	    if((fgets(line,133,mapfile[filen]))==NULL)
	      die("Unexpected mapfile end");}
	  goto C;}
	ychp=1;
      	sscanf(line,"CHIP %d %f %f %f %f",&chip,&slmin,&slmax,&lmin,&lmax);
	if(nshuffle) inshuffle = (slmax>slmin) ? nshuffle : -nshuffle;
	//coef_disp data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d b\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_disp;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d c\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_disp[filen][i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d d\n",slitnum);
	    return 1;}}
	//coef_xdisp data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d b\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_disp;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d c\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_xdisp[filen][i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d d\n",slitnum);
	    return 1;}}
	//coef_sag data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d e\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_sag;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d f\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_sag[filen][i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d g\n",slitnum);
	    return 1;}}
	//coef_tilt data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d h\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_tilt;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d i\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_tilt[i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d j\n",slitnum);
	    return 1;}}
	//coef_sagit data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d k\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_sagit;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d l\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_sagit[i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d m\n",slitnum);
	    return 1;}}
	//coef_slen data
	if((fgets(line,133,mapfile[filen]))==NULL){
	  printf("Unexpected end to mapfile slit %d n\n",slitnum);
	  return 1;}
	lin=&line[0];
	for(i=0;i<=ord_slen;i++){
	  if((lin=strpbrk(lin,"1234567890.-"))==NULL){
	    printf("Unexpected end to mapfile slit %d o\n",slitnum);
	    return 1;}
	  sscanf(lin,"%f",&coef_slen[i]);
	  if((lin=strpbrk(lin," "))==NULL){
	    printf("Unexpected end to mapfile slit %d p\n",slitnum);
	    return 1;}}
    	if(lmin>max_lambda || lmax<min_lambda) goto C;
	if(lmin<min_lambda) lmin=min_lambda;
	if(lmax>max_lambda) lmax=max_lambda;
	if(lmax<=lmin+10.) goto C;
	lambda=lmin;
	xcen=polyvalue(lambda,coef_disp[filen],ord_disp)/ibin;
	if(xcen<0) xcen=0;
	if(xcen>ixmx-1) xcen=ixmx-1;
	ix=(int) xcen;
	//direction,value of dispersion
	dsign = (polyvalue(lmax,coef_disp[filen],ord_disp)/ibin>xcen) ? 1 : -1;
	ssign = (slmax>slmin) ? 1: -1;
	disp=(lmax-lmin)/(polyvalue(lmax,coef_disp[filen],ord_disp)-polyvalue
			  (lmin,coef_disp[filen],ord_disp));

	//if first file, get spectrum info, setup slit data files
	
	if(!filen){
	  slvn=wlvn=-1000;
	  slv1=wlv1=20000;
	  //direction,value of dispersion
	  if(diag[0]=='s') *wval=0.5*(lmax+lmin);
	  dsign = (polyvalue(lmax,coef_disp[filen],ord_disp)/ibin>xcen) ? 1 : -1;
	  ssign = (slmax>slmin) ? 1: -1;
	  disp=(lmax-lmin)/(polyvalue(lmax,coef_disp[filen],ord_disp)-polyvalue
			    (lmin,coef_disp[filen],ord_disp));
	    
	  //if searching for spectrum cent, use 1st spectrum to find offset 
	  //from predicted loc
	  ixl=(int) xcen;
	  proff=0;
	  if(search){
	    for(i=0;i<srcsz;i++) *(prfl+i)=0;
	    while(ixl<ixmx && ixl>=0){
	      lambda=polyvalue(ixl*ibin,coef_xdisp[filen],ord_disp);
	      if(lambda<lmin || lambda>lmax) goto D;
	      iyy=(int)polyvalue(lambda,coef_sag[filen],ord_sag)/ibin;
	      if(xdisper){
		ixx=ixl;}
	      else{
		ixx=iyy;
		iyy=ixl;}
	      prmax=-10000.;
	      j=0;
	      for(i=0;i<srcsz;i++){
		k=iyy+i-search;
		if(k<0 || k>=naxes[1]) continue;
		if(*(*(array[0]+k)+ixx)>prmax){
		  prmax=*(*(array[0]+k)+ixx);
		  j=i;}
	        }
	      *(prfl+j)= *(prfl+j)+1;;
	  D:    ixl+=dsign;}
	    j=0;
	    for(i=0;i<srcsz;i++)
	      if(*(prfl+i)>j){
		j=*(prfl+i);
		proff=i-search;}
	  }
	  if(dimen==2){
	    isloff[nslit]=(int)(((slmin-proff)*slit_len/(slmax-slmin))/
                          delta_slit)+1;
	    noff[nslit]=(int)(((slmax-proff)*slit_len/(slmax-slmin))/
                         delta_slit)-isloff[nslit];
	    if(noff[nslit]>n_slitpix) noff[nslit]=n_slitpix;}
	  if(clean){
	    if(0){
	      size=nfile*strsz*(1+(int)dsign*(polyvalue(lmax,coef_disp[filen],
		   ord_disp)/ibin-ix));}
	    else{
	      size=nfile*((int)(1.2*ssign*(slmax-slmin+1)/ibin))*(1+(int)dsign*
		   (polyvalue(lmax,coef_disp[filen],ord_disp)/ibin-ix));}
	    indx=realloc(indx,sizeof(INT)*size);
	    indy=realloc(indy,sizeof(INT)*size);
	    indf=realloc(indf,sizeof(INT)*size);
	    lamval=realloc(lamval,sizeof(FLOAT)*size);
	    flxval=realloc(flxval,sizeof(FLOAT)*size);
	    slval=realloc(slval,sizeof(FLOAT)*size);
	    stdev=realloc(stdev,sizeof(FLOAT)*size);
	    ones=realloc(ones,sizeof(FLOAT)*size);
	    for(j=0;j<size;j++) *(ones+j)=1.0; 
	    nint=0;}
	  }
   
	/**********************CR cleaning******************************************/
  	
	if(clean){
	  //do trace, get Flux(lambda,slitpos) for each spectrum
	  //loop over all x values for which lambda<max_lambda
	  lambda=lmin;
	  ix=(int)xcen;
	while(ix<ixmx && ix>=0){
	  if(nint==size) break;
	  lambda=polyvalue(ix*ibin,coef_xdisp[filen],ord_disp);
	  ycen=polyvalue(lambda,coef_sag[filen],ord_sag)/ibin;
	  slnt=polyvalue(lambda,coef_slen,ord_slen)/ibin;
	  tilt=polyvalue(lambda,coef_tilt,ord_tilt)/ibin;
	  sagt=polyvalue(lambda,coef_sagit,ord_sagit)/ibin;
   	  sagsn=1;
	  if(sagt<0){
	    sagt=-sagt;
	    sagsn=-1;}
	  rag=slnt*slnt/(8.*sagt);
	  //	  if(!strip){
	  if(1){
	    iytop=(int)(ycen+ssign*slmax*slnt/(slmax-slmin));
	    iybot=(int)(ycen+ssign*slmin*slnt/(slmax-slmin))+1;}
	  else{
	    iytop=(int)(ycen+proff+strip)+1;
	    iybot=(int)(ycen+proff-strip);}
	  if(iytop>=iymx) iytop=iymx-1;
	  if(iybot<0) iybot=0;
	    i1=iybot;
	    i2=iytop;
	  any=0;
	  ni=abs(i2-i1)+1;
	  i=i1-1;	  
	  for(iii=0;iii<ni;iii++){
	    i++;
	    if(i<0 || i>=iymx) continue;
	    xxx=ix-tilt*(i-ycen)/slnt-sagsn*(rag*(1-(i-ycen)*(i-ycen)/(2.*rag
		*rag))-rag+sagt); 
	    lambda=polyvalue(xxx*ibin,coef_xdisp[filen],ord_disp);
	    if(lambda>lmax) continue;
	    any=1;
	    *(lamval+nint)=lambda;
	    if(xdisper){
	      ixx=ix;
	      iyy=i;}
	    else{
	      ixx=i;
	      iyy=ix;}
	    *(slval+nint)=(i-ycen-proff);
	    if(*(slval+nint)<slv1) slv1=*(slval+nint);
	    if(*(lamval+nint)<wlv1) wlv1=*(lamval+nint);
	    if(*(slval+nint)>slvn) slvn=*(slval+nint);
	    if(*(lamval+nint)>wlvn) wlvn=*(lamval+nint);
	    *(flxval+nint)= *(*(array[filen]+iyy)+ixx)/exptime[filen];
	    if(clean || optimal) 
	      *(stdev+nint)=sqrt(*(*(s_array[filen]+iyy)+ixx)*gain+noise*noise)/
                            exptime[filen];
	    *(indx+nint)=ixx;
	    *(indy+nint)=iyy;
	    *(indf+nint)=filen;
	    nint++;
	    if(nint==size)break;}
	  if(nint==size) break;
	  ix+=dsign;}
	}
	goto C;}
      if(!ychp) continue;
       
      if(clean){
	if(!nint) continue;
      
    
    /*--------------Fit splines to data, clean if necessary------------------*/

      //spline arrays
      
	if(nint == size) nint--;
      nknotwl=(int)((wlvn-wlv1)/(wldknot*disp*dsign))+1;
      nknotsl=(int)(slvn-slv1)/sldknot;
      nestwl=nknotwl+2*wlorder+2;
      nestsl=nknotsl+2*slorder+2;
      nestm = (nestwl>nestsl) ? nestwl: nestsl;
      if(!(knotwl=realloc(knotwl,sizeof(FLOAT)*nestm))) 
	                                       die("\nMemory failure knotwl");
      for(i=0;i<nknotwl;i++) *(knotwl+i)=wlv1+.001+i*wldknot*disp*dsign;
      if(wlvn<=*(knotwl+nknotwl-1)) wlvn=*(knotwl+nknotwl-1)+.001;
      if(!(knotsl=realloc(knotsl,sizeof(FLOAT)*nestm))) 
	                                       die("\nMemory failure knotsl");
      for(i=0;i<nknotsl;i++) *(knotsl+i)=slv1+i*sldknot;
      if(slvn<=*(knotsl+nknotsl-1)) slvn=*(knotsl+nknotsl-1)+.001;
      uu=nestwl-wlorder-1;
      vv=nestsl-slorder-1;
      morder = (wlorder>slorder) ? wlorder+1: slorder+1;
      bx=wlorder*vv+slorder+1;
      by=slorder*uu+wlorder+1;
      if(bx<=by){
	b1=bx;
	b2=b1+vv-slorder;}
      else{
	b1=by;
	b2=b1+uu-wlorder;}
      lwork1=uu*vv*(2+b1+b2)+2*(uu+vv+morder*(nint+nestm)+nestm-
				wlorder-slorder)+b2+1;
      if(!(work1=realloc(work1,sizeof(FLOAT)*lwork1)))
	                                        die("\nMemory failure work1");
      lwork2=uu*vv*(6*vv+2)+6*vv+1;
      if(!(work2=realloc(work2,sizeof(FLOAT)*lwork2)))
	                                        die("\nMemory failure work2");
      kwork=nint+(nestwl-2*wlorder-1)*(nestsl-2*slorder-1);
      if(!(iwork=realloc(iwork,sizeof(INT)*kwork))) 
	                                        die("\nMemory failure iwork");
      if(!(coefs=realloc(coefs,sizeof(FLOAT)*nestwl*nestsl)))
	                                         die("\nMemory failure coef");
      iopt=-1;
      ier=0;
      v1=1.0e-10;
     //fit spline to spectrum
      surfit_(&iopt,&nint,lamval,slval,flxval,ones,&wlv1,&wlvn,&slv1,&slvn,
	      &wlorder,&slorder,&smfac,&nestwl,&nestsl,&nestm,&v1,
	      &nknotwl,knotwl,&nknotsl,knotsl,coefs,&resid,work1,&lwork1,
	      work2,&lwork2,iwork,&kwork,&ier);
      if(ier) printf("%d\n",ier);
    
      //clean cosmic rays
	for(i=0;i<nint;i++){
	  aa= *(lamval+i);
	  bb= *(slval+i);
	  bispev_(knotwl,&nknotwl,knotsl,&nknotsl,coefs,&wlorder,&slorder,&aa,
                  &one,&bb,&one,&cc,work1,&lwork1,iwork,&kwork,&ier);
	  if(!ier && *(flxval+i)>cc+ *(stdev+i)*siglimit){
	    ixx= *(indx+i);
	    if(ixx==0) ixx=1;
	    if(ixx==naxes[0]-1) ixx=naxes[0]-2;
	    iyy= *(indy+i);
	    if(iyy==0) iyy=1;
	    if(iyy==naxes[1]-1) iyy=naxes[1]-2;
	    j= *(indf+i);
	    //	    printf("%d %d %d %d\n",j,chip,ixx,iyy);
	    for(ix=-1;ix<=1;ix++){
	      for(iy=-1;iy<=1;iy++){
		*(*(weight[j]+iyy+iy)+ixx+ix)=0;
		*(*(array[j]+iyy+iy)+ixx+ix)=0.;}
	      }
	  }
	}
      
      
      //diagnostics
      while(4){
	if(diag[0]!='n'){
	  if(diag[0]=='s') *wval=0.5*(lmax+lmin);
	  if(diag[0]=='l' && (lmin>5570. || lmax<5590.))break;
	  cpgpage;
	  fmin=100000.;
	  fmax=-100000.;
	  for(i=1;i<nint;i++){
	    if(*(lamval+i)<*(wval+0)-5. || *(lamval+i)>*(wval+nwval-1)+5.)
               continue;
	    if(*(flxval+i)<fmin)fmin=*(flxval+i);
	    if(*(flxval+i)>fmax)fmax=*(flxval+i);}
	  fmax=fmax+0.1*(fmax-fmin);
	  fmin=fmin-0.1*(fmax-fmin);
	  cpgpage;
	  cpgsch(1);
	  cpgscr(0,1,1,1);
	  cpgscr(1,0,0,0);
	  cpgask(0);
	  cpgsci(1);
	  cpgslw(4);
	  if(diag[0]=='s'){
	    cpgenv(slv1,slvn,fmin,fmax,0,0);
	    for(i=0;i<nint;i++){
	      if(*(lamval+i)>*wval-5. && *(lamval+i)<*wval+5.)
	            cpgpt(1,slval+i,flxval+i,-1);}
	    }
	  else{
	    cpgenv(5527.,5627.,fmin,fmax,0,0);
	    for(i=0;i<nint;i++){
	      if(*(slval+i)>-3. && *(slval+i)<3.)
                    cpgpt(1,lamval+i,flxval+i,-1);}
	    }
	  cpgslw(1);
	  bispev_(knotwl,&nknotwl,knotsl,&nknotsl,coefs,&wlorder,&slorder,wval,
                  &nwval,sval,&nsval,flxval,work1,&lwork1,iwork,&kwork,&ier);
	  cpgsci(2);
	  if(diag[0]=='s') cpgline(nsval,sval,flxval);
	  else cpgline(nwval,wval,flxval);
	  cpgsci(1);
	  printf("\nHit return to continue, q to end ");
	  fflush(stdout);
	  fgets(line,80,stdin);
	  if(*line=='q' || *line=='Q') return 0;
		 cpgclos;
	  printf("                                       %d %d\n",ier,nint);
	  nint=0;
	  break;}
        break;}//end of diagnostics
         }//end of CR cleaning   
      
      /*******************************extract spectrum*******************************/

	for(k=0;k<nfile;k++){
	  for(i=0;i<naxes[1];i++){
	    for(j=0;j<naxes[0];j++){
	      *(*(twght+i)+j) += *(*(weight[k]+i)+j);
	      *(*(weight[k]+i)+j)=1;}
	    }
	}
	lvmin=((int)((lmin-min_lambda)/delta_lambda));
	lvmax=((int)((lmax-min_lambda)/delta_lambda));
	if(lvmin<0) lvmin=0;
	if(lvmax>n_lampix-1) lvmax=n_lampix-1;
	nlv=(int)lvmax-lvmin + 1;

	//2d extraction
	if(dimen==2){	  
	  islff=(int)((slmin*slit_len/(slmax-slmin))/delta_slit);
	  sloff=islff*delta_slit;
	  for(filen=0;filen<nfile;filen++){
	    for(j=lvmin;j<lvmax;j++){
	      lambda=min_lambda+j*delta_lambda;
	      xcen=polyvalue(lambda,coef_disp[filen],ord_disp);	 
	      ycen=polyvalue(lambda,coef_sag[filen],ord_sag);
	      slnt=polyvalue(lambda,coef_slen,ord_slen);
	      tilt=polyvalue(lambda,coef_tilt,ord_tilt);
	      scatl=slnt/slit_len;
	      for(i=0;i<noff[nslit];i++){
		slitpos=sloff+(i+1)*delta_slit;
		slitpos*=scatl;
		ypos=(ycen+slitpos)/ibin;
		xpos=(xcen+tilt*slitpos/slnt)/ibin;
		
		/******************need to add curvature here*******************\
		 *                                                               *
                \***************************************************************/
		if(!xdisper){
		  yp=ypos;
		  ypos=xpos;
		  xpos=yp;}
		if(xpos<0 || ypos<0 || xpos>naxes[0]-2 || ypos>naxes[1]-2)continue;
		if(i>n_slitpix || j>n_lampix){
		  printf("!! %f %f %d %d\n",xpos,ypos,i,j);
		  fflush(stdout);}
		wt=f_interpol(twght,naxes,xpos,ypos);
		if(wt>0)*(*(spectrum+i)+j)+=f_interpol(array[filen],naxes,xpos,ypos)
                                            /wt;
		if(nshuffle){
		  ypos+=inshuffle;
		  wt=f_interpol(twght,naxes,xpos,ypos);
		  if(wt>0) *(*(spectrum+i)+j) -= f_interpol(array[filen],naxes,xpos,
                                                 ypos+inshuffle)/wt;}
	        }
	      }
	    }
	  }

	//1d extraction
	if(dimen==1){
	  sloff=proff-strip;
	  for(filen=0;filen<nfile;filen++){
	    for(j=lvmin;j<lvmax;j++){
	      lambda=min_lambda+j*delta_lambda;
	      xcen=polyvalue(lambda,coef_disp[filen],ord_disp);	 
	      ycen=polyvalue(lambda,coef_sag[filen],ord_sag);
	      slnt=polyvalue(lambda,coef_slen,ord_slen);
	      tilt=polyvalue(lambda,coef_tilt,ord_tilt);
	      for(i=0;i<strsz;i++){
		slitpos=i+proff-strip;
		ypos=(ycen/ibin)+slitpos;
		xpos=(xcen+tilt*slitpos/slnt)/ibin;
		
		/******************need to add curvature here*******************\
		 *                                                               *
                \***************************************************************/
		if(!xdisper){
		  yp=ypos;
		  ypos=xpos;
		  xpos=yp;}
		if(xpos<0 || ypos<0 || xpos>naxes[0]-2 || ypos>naxes[1]-2)continue;
		if(j>n_lampix){
		  printf("!! %f %f %d %d\n",xpos,ypos,i,j);
		  fflush(stdout);}
		wt=f_interpol(twght,naxes,xpos,ypos);
		if(wt>0) *(*(spectrum)+j)+=f_interpol(array[filen],naxes,xpos,ypos)
                                          /wt;}
	      }
	    }
	}


	for(i=0;i<naxes[1];i++){
	  for(j=0;j<naxes[0];j++) *(*(twght+i)+j)=0;}
    }
      
  END:
    continue;}
  /*********************write out spectra************************************/
 
  if(diag[0]!='n') return 0;
  for(i=0;i<n_slit;i++){
    newaxes[0]=n_lampix;
    if(dimen==2){
      newaxes[1]=noff[i];
      flen=noff[i]*n_lampix;
      //output hdu
      fits_create_img(outptr,FLOAT_IMG,2,newaxes,&status);}
    else{
      flen=n_lampix;
      fits_create_img(outptr,FLOAT_IMG,1,newaxes,&status);}
    if(status){
      printf("Error creating spectrum file\n");
      return 1;}
    //first hdu? write info
    if(!i){
      if(dimen==2)fits_write_key(outptr,TFLOAT,"D_SLIT",&delta_slit,
                                 "slit interval in arcsec",&status);
      fits_write_key(outptr,TINT,"N_SLITS",&n_slit,"Number of spectra",
                     &status);
      fits_write_key(outptr,TFLOAT,"CRVAL1",&min_lambda,"Starting wavelength",
                     &status);
      fits_write_key(outptr,TFLOAT,"CDELT1",&delta_lambda,"Delta lambda",
                     &status);}
    if(status){
      printf("Unable to create output spectrum file (%d)\n",status);
      return 1;}
    if(dimen==2){
      isloff[i]=-isloff[i];
      fits_write_key(outptr,TINT,"CNTRLINE",&isloff[i],"Spectrm central row",
		     &status);}
    fits_write_key(outptr,TSTRING,"OBJECT",&name[80*i],"Name of object",&status);
    fits_write_key(outptr,TINT,"SLITNUM",&sltnum[i],"Slit number",&status);
    if(status){
      printf("Unable to create output spectrum file (%d)\n",status);
      return 1;}  
    fits_write_pix(outptr,TFLOAT,firstelem,flen,*(stack+i),&status);
    if(status){
      printf("Error writing spectrum file %d\n", status);
      return 1;}
    }
    return 0;}

