/*****************************************************************************\
*                                                                             *
*  IFU-IMAGE    extracts the spots from an ifu direct image and reconstructs  *
*               the focal plane images                                        *
*                                                                             *
*  VERSION       05 Dec  2003                                                 *
*                                                                             *
\*****************************************************************************/

#include <stdlib.h>   
#include <stdio.h>
#include <math.h>
#include <string.h>

#include "ioutils.h"
#include "kdcutil.h"
#include "mgutils.h"
#include "optutils.h"
#include "fitsio.h"
#include "cosmos.h"
#include "clardy.h"

int  main(int argc,char *argv[]){
 
  int      bitpix,naxis,nob[9],status,i,chip,n,ind,boxwdth,boxht,halfht,halfwd,
           nobj,nelem,j,INT,anynl,subr,bflag,ixp,iyp,thisone,noj,ii,jj,
           biaslins,flatf,chp[2000],xaxis,yaxis,bx0,bx1,by0,by1,overscan,
           hdutype,nulvl,indx[2000][9],ibin;
  int      *INTP,*ifmap1,*ifmap2;
  float    FLOAT,xccd[2000],yccd[2000],xfp,yfp,xmid,ymid,sum,fxcorn,fycorn,
           fixp,dix,fiyp,diy,value,d11,d12,d21,d22,hwidth,maxap,flux[2001];
  float    *FLOATP, **array,*image,**farray,*fimage,**farray2,*fimage2,**row,
           *sbox,*ifimage;
  double   cur_wavl, cur_temp,temp;
  char     flnm[80],file[80],ofile[80],imacsdir[133],line[133],flatfile[80],
           dfile[80],ifile[80],CHAR;
  char     *COS_HOME,*HOME,*DATA_DIR;
  long     boxarea,naxes[2],firstelem[3],firstpt[2],npts[2],firstcn[2],
           lastcn[2],offset,inc[2];
  Obs      *obset = NULL;
  element  *instrument;
  vect3    mskpos,ccdpos;
  objq     *oq, *oq1;
  slit     slitdat;
  obsdef   obsdata;
  fitsfile *fptr[9],*flptr;  
  fitsdef  fitsdata,flatdata;
  int off=0;

  flatf=0;
  nulvl=0;
  firstelem[0]=firstelem[1]=firstelem[2]=1;
  inc[0]=inc[1]=1;

  //directories
  COS_HOME=malloc(sizeof(CHAR)*80);
  HOME=malloc(sizeof(CHAR)*80);
  DATA_DIR=malloc(sizeof(CHAR)*80);
  DATA_DIR=getenv("COSMOS_IMAGE_DIR");
  if(DATA_DIR==NULL){
    printf("COSMOS_IMAGE_DIR undefined!\n");
    return 1;}
  strcat(DATA_DIR,"/");
  COS_HOME=getenv("COSMOS_HOME");
  if(COS_HOME==NULL){
    printf("COSMOS_HOME undefined!\n");
    return 1;}
  HOME=getenv("HOME");
  //program parameters
  strcpy(file,"ifu-image");
  if(OpenCosParm(file)!=0) die("Cannot open ifu-image parameter file!");
  if(ReadParm_s("FLAT_FILE",flatfile)==0 && strcasecmp(flatfile,"none")){
    flatf=1;
    strcpy(file,DATA_DIR);
    strcat(file,flatfile);
    strcat(file,".fits");
    strcpy(flatfile,file);}
  if(ReadParm_s("OBSDEF",ofile)==1) die("parameter file error\n");
  

  //data not on command line

  if(argc<2){
    while(1){
      printf("Enter image file name:   ");
      scanf("%s",dfile);
      strcpy(ifile,DATA_DIR);
      strcat(ifile,dfile);
      thisone=0;
      for(i=1;i<=8;i++){
	strcpy(file,ifile);
	strcat(file,"c");
	sprintf(line,"%d.fits",i);
	strcat(file,line);
	status=OpenFitsFile(file,&fptr[i],&fitsdata);
	if(!status){
	  thisone=i;
	  if(flatf){
	    status=OpenFitsFile(flatfile,&flptr,&flatdata);
	    if(status){
	      printf("unable to read flatfield file\n");
	      return 1;}
	    }	
	  }
        }
      if(!thisone){
	printf("cannot find frames \n");
	continue;}
      break;}
    }

  //data on command line

  else{
     //image file
    strcpy(ifile,DATA_DIR);
    strcpy(dfile,argv[1]);
    strcat(ifile,dfile);
    thisone=0;
    for(i=1;i<=8;i++){
      strcpy(file,ifile);
      strcat(file,"c");
      sprintf(line,"%d.fits",i);
      strcat(file,line);
      status=0;    
      status=OpenFitsFile(file,&fptr[i],&fitsdata);
      if(!status){
	thisone=i;
	if(flatf){
	  status=OpenFitsFile(flatfile,&flptr,&flatdata);
	  if(status) die("unable to read flatfield file");}
        }
      }
    if(!thisone) die("cannot find frames");}

  //get image parameters

  ibin=fitsdata.binning;
  if(ibin!=1 || fitsdata.ybinning) die("ifu-image requires a 1x1 binned image");
  subr=fitsdata.subrstr;
  biaslins=fitsdata.biaslins;
  overscan=fitsdata.overscan;
  naxes[0]=2048+overscan;
  naxes[1]=4096+biaslins;
  nelem=naxes[0]*naxes[1];
  if(subr){
    firstpt[0]=fitsdata.subx[0];
    firstpt[1]=fitsdata.suby[0];
    npts[0]=fitsdata.subx[1]-fitsdata.subx[0]+1+overscan;
    npts[1]=fitsdata.suby[1]-fitsdata.suby[0]+1+biaslins;}
  image=malloc(sizeof(FLOAT)*naxes[0]*naxes[1]);
  array=malloc(sizeof(FLOATP)*naxes[1]);
  for(j=0;j<naxes[1];j++) *(array+j)=image+naxes[0]*j;

  //get flatfield

  fimage=malloc(sizeof(FLOAT)*65536);
  fimage2=malloc(sizeof(FLOAT)*65536);
  if(flatf){
    if(flatdata.binning!=1 || flatdata.subrstr || flatdata.naxes[0]!=256
       || flatdata.naxes[1]!=256) die("Wrong flatfield characteristics");
    farray=malloc(sizeof(FLOATP)*256);
    farray2=malloc(sizeof(FLOATP)*256);
    for(j=0;j<flatdata.naxes[1];j++){ 
      *(farray+j)=fimage+flatdata.naxes[0]*j;
      *(farray2+j)=fimage2+flatdata.naxes[0]*j;}
    status=0;
    fits_read_pix(flptr,TFLOAT,firstelem,65536,&nulvl,fimage,&anynl,&status);
    if(status)fits_die("Flat field file error",status);
    fits_movrel_hdu(flptr,1,NULL,&status);
    if(status)fits_die("flat field error",status);
   fits_read_pix(flptr,TFLOAT,firstelem,65536,&nulvl,fimage2,&anynl,&status);

    //normalize

    n=0;
    sum=0;
    for(i=0;i<256;i++){
      for(j=0;j<256;j++){
	if(*(farray[i]+j)<=0) continue;
	sum+= *(farray[i]+j);
	n++;}
      }
    sum/=n;
    for(i=0;i<65536;i++) *(fimage+i)/=sum;
    n=0;
    sum=0;
    for(i=0;i<256;i++){
      for(j=0;j<256;j++){
	if(*(farray2[i]+j)<=0) continue;
	sum+= *(farray2[i]+j);
	n++;}
      }
    sum/=n;
    for(i=0;i<65536;i++) *(fimage2+i)/=sum;}
  else{
    for(i=0;i<65536;i++) *(fimage+i)= *(fimage2+i)=1.;}
  if(flatf){
    if(flatdata.binning!=1 || flatdata.subrstr || flatdata.naxes[0]!=256
       || flatdata.naxes[1]!=256) die("Wrong flatfield characteristics");
    farray=malloc(sizeof(FLOATP)*256);
    for(j=0;j<flatdata.naxes[1];j++) *(farray+j)=fimage+flatdata.naxes[0]*j;
    status=0;
    fits_read_pix(flptr,TFLOAT,firstelem,65536,&nulvl,fimage,&anynl,&status);
    if(status) fits_die("Flat field file error",status);
    //normalize
    n=0;
    sum=0;
    for(i=0;i<256;i++){
      for(j=0;j<256;j++){
	if(*(farray[i]+j)<=0) continue;
	sum+= *(farray[i]+j);
	n++;}
      }
    sum/=n;
    for(i=0;i<65536;i++) *(fimage+i)/=sum;}
  else{
    for(i=0;i<65536;i++) *(fimage+i)=1.;}

  //observational/instrumental setup

  if(ReadObsDef(ofile,&obsdata)!=0) die("Cannot open observ definition file");
  if(strcmp(obsdata.mode,"DIRECT")) die("ifu-image requires a direct image");
  temp=obsdata.temp;
  //camera data
  strcpy(imacsdir,COS_HOME);
  strcat(imacsdir,"/sdata/");
  strcpy(flnm,imacsdir);
  strcat(flnm,obsdata.dewar);
  if(SetupCamera(obsdata)==1) return 1;
  //optical data
  SetupInstr(&obsdata,&instrument);
  //mask data
  strcpy(flnm,imacsdir);
  strcat(flnm,"IFU.SMF");
  obset=read_smdf(flnm,NULL,0);
  if(obset == NULL)("No data in mask file");
  cur_wavl=  obset->cw;
  cur_temp=obset->temp;


  //find positions of all fiber spots
    
  for(i=1;i<=8;i++) nob[i]=0;
  nobj=1;
  oq=obset->ob;
  oq1=oq;
  maxap=0.;
  for(i=0;i<=2000;i++) flux[i]=0;

  while(1){
    slitdat=oq->slit;
    mskpos = get3de2v(oq->smpos,0.0);
    ccdpos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
    xfp=ccdpos.x;
    yfp=ccdpos.y;
    //position fudge
    noj=nobj-off;
    if(noj<0) noj+=2000;
    chip=fp2ccd(xfp,yfp,&xccd[noj],&yccd[noj],cur_wavl);
    //is aperture on a chip?
    if(chip){
      chp[noj]=chip;
      //need to convert to pixels!!!
      hwidth=(slitdat.width)/2.+3;
      indx[nob[chip]][chip]=noj;
      nob[chip]++;}
    flux[nobj]=0.;
    nobj++;
    oq=oq->next;
    if(oq==oq1 || nobj>2000) break;}

  //extraction box
  boxwdth=boxht=2*((int)(hwidth));
  boxarea=boxwdth*boxht;
  halfwd=halfht=boxwdth/2;
  sbox=malloc(sizeof(INT)*boxwdth*boxht);
  row=malloc(sizeof(INTP)*boxht);
  for(i=0;i<boxht;i++){
    row[i]=sbox+i*boxwdth;
    for(j=0;j<boxwdth;j++) *(row[i]+j)=1;}

  //for each chip, locate each alignment hole image

  //read in image
  for(chip=1;chip<=8;chip++){
    if(nob[chip]==0) continue;
    if(fptr[chip]==NULL) die("Missing chip data");
    printf("Finding spots on chip %d\n",chip);
    fflush(stdout);
    status=0;
    if(!subr){
      fits_read_pix(fptr[chip],TFLOAT,firstelem,nelem,&nulvl,image,&anynl,&status);}
    else{
      firstcn[0]=1;
      lastcn[0]=npts[0];
      for(i=1;i<=npts[1];i++){
	firstcn[1]=lastcn[1]=i;
	offset=(naxes[0]*(i+firstpt[1]-1))+firstpt[0]-1;
	fits_read_subset(fptr[chip],TFLOAT,firstcn,lastcn,inc,&nulvl,image+offset,
                         &anynl,&status);}
      }
    if(status){
      printf("Error %d reading data for chip %d\n",status,chip);
      return 1;}
    //subttract bias strips
    if(biaslins>0 && overscan>0){
      xaxis=naxes[0]-overscan;
      yaxis=naxes[1]-biaslins;
      bx0=xaxis;
      bx1=naxes[0]-1;
      by0=yaxis;
      by1=naxes[1]-1;
      subbias(array,naxes,bx0,bx1,by0,by1,xaxis,yaxis);}
    for(n=0;n<nob[chip];n++){
      ind=indx[n][chip];
      xmid=xccd[ind]/ibin;
      ymid=yccd[ind]/ibin;

      //sum over aperture

      sum=0.;
      fxcorn=(xmid-halfwd);
      fycorn=(ymid-halfht);
      bflag=0;
      for(ii=0;ii<boxwdth;ii++){
	fixp=fxcorn+ii;
	if(fixp<0 || fixp>=naxes[0]){
	  bflag=1;
	  break;}
	ixp= (int) fixp;
	dix=fixp-ixp;
	for(jj=0;jj<boxht;jj++){
	  fiyp=fycorn+jj;
	  if(fiyp<0 || fiyp>naxes[1]){
	    bflag=1;
	    break;}
	  iyp=(int) fiyp;
	  diy=fiyp-iyp;
	  if(dix==0){
	    value= *(*(array+iyp)+ixp)*(1-diy)+*(*(array+iyp+1)+ixp)*diy;}
	  else{
	    if(diy==0){
	      value= *(*(array+iyp)+ixp)*(1-dix)+*(*(array+iyp)+ixp+1)*dix;}
	    else{
	      d11=sqrt(dix*dix+diy*diy);
	      d21=sqrt((1-dix)*(1-dix)+diy*diy);
	      d12=sqrt(dix*dix+(1-diy)*(1-diy));
	      d22=sqrt((1-dix)*(1-dix)+(1-diy)*(1-diy));
	      value= *(*(array+iyp)+ixp)*d11 +
	             *(*(array+iyp)+ixp+1)*d21 +
	             *(*(array+iyp+1)+ixp)*d12 +
	             *(*(array+iyp+1)+ixp+1)*d22;
	      value/=(d11+d12+d21+d22);}
	    }
	  sum+=value*(*(row[jj]+ii));}
        }      
      flux[ind]=sum/boxarea;}
    fits_close_file(fptr[chip],&status);}
  free(image);
  free(array);

  //create focal plane images

  //read in ifu maps

  strcpy(file,COS_HOME);
  strcat(file,"/sdata/ifu-map.fits");
  status=0;
  fits_open_file(&fptr[1],file,READONLY,&status);
  if(status) fits_die("map file error",status);
  fits_get_img_param(fptr[1],2,&bitpix,&naxis,naxes,&status);
  nelem=naxes[0]*naxes[1];
  ifmap1=malloc(sizeof(INT)*nelem);
  fits_read_pix(fptr[1],TINT,firstelem,nelem,&nulvl,ifmap1,&anynl,&status);
  if(status) fits_die("Error %d reading ifu map",status);
  fits_movrel_hdu(fptr[1],1,&hdutype,&status);
  if(status) ("Error locating ifu map",status);
  fits_get_img_param(fptr[1],2,&bitpix,&naxis,naxes,&status);
  ifmap2=malloc(sizeof(INT)*nelem);
  fits_read_pix(fptr[1],TINT,firstelem,nelem,&nulvl,ifmap2,&anynl,&status);
  if(status) fits_die("Error reading ifu map",status);

  //output images

  strcpy(file,"!");
  strcat(file,DATA_DIR);
  strcat(file,dfile);
  strcat(file,"_ifu.fits");
  status=0;
  fits_create_file(&fptr[2],file,&status);
  ifimage=malloc(sizeof(FLOAT)*nelem);

  //object ifu
  fits_create_img(fptr[2],32,2,naxes,&status);
  for(i=0;i<65536;i++) if(*(fimage+i)) *(ifimage+i)=flux[*(ifmap1+i)]/
                                       (*(fimage+i));
  fits_write_pix(fptr[2],TFLOAT,firstelem,nelem,ifimage,&status);
  if(status) fits_die("Error writing ifu images",status);
  //field ifu
  fits_create_img(fptr[2],32,2,naxes,&status);
  for(i=0;i<65536;i++) if(*(fimage+i)) *(ifimage+i)=flux[*(ifmap2+i)]/
                                       (*(fimage2+i));
  fits_write_pix(fptr[2],TFLOAT,firstelem,nelem,ifimage,&status);
  if(status){
    printf("Error %d writing ifu images\n",status);
      return 1;}
  fits_close_file(fptr[2],&status);
  return  0;
}
  
