/*
  ldss3-pattern  removes pattern noise from ldss3 data
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "rfftw.h"
#include "fitsio.h"
#include "cosmos.h"
#include "cpgplot.h"


#define DELIMITERS ",:[]"

// function headers
void fitssec(char *sec, int ii, long *val);
void sub_img(float *image, float *image_o, long nelem, long x0, long x1, 
             long y0, long y1, long x);
void add_img(float *image, float *image_o, float value, long nelem, long x0, 
             long x1, long x);
int comp_nums(const float *, const float *);
float f_divide_zero(float x, float y, float repl);
float median(float *array, long nelem);
void gauss(float *array, float *array_o, int radius, float sigma,long nelem);
void gauss_fft(float *array, float *array_o, int radius, float sigma,
               long nelem);
void biweight(float *array, float *array_o, int iter, long nelem);


// main
int main(int argc,char *argv[]){

   // variables
   int       anynull,biaslins,bitpix,bytepix,hdupos,hdutype,i,intermediate,iter,
             j,k,l,m,n,naxis,nchip,nkeys,nullval,overscan,pnaxis,radius,status,
             top,xsize,ysize,ncut;
   char      biassec[80],card[81],datasec[80],dfile[80],file[80],file_o[80],
             indewar[80],key[FLEN_CARD],line[133],string[133],tfile_o[80],
             par[133];
   long      Anaxes[3],Anelem,Aymin,Aymax,bnaxes[3],bnelem,bxmin,bxmax,bymin,
             bymax,cnaxes[3],cnelem,cnelem2,cxmin,cxmax,cymin,cymax,dnaxes[3],
             dnelem,dxmin,dxmax,dymin,dymax,naxes[3],nelem,pnaxes[2],pnelem,
             qnelem,r1naxes[3],r1nelem,r1nelem2,r1xmin,r1xmax,r1ymin,r1ymax,
             fpixel,r2naxes[3],r2nelem,r2nelem2,r2xmin,r2xmax,r2ymin,r2ymax,
             tnelem,u,v;
   float     alpha,bwt[2],level,levels1,levels2,mmP1dfr, mPsdfpms,product,r,x0,
             x1,y0,y1,y,z;

   // pointers
   char      *datadir;
   long      *Anb2,*And2;
   float     *Anmag,*AP1dfr3,*cimage,*csort,*cut,*DmPf,*DmPfn,*DmPfd,*mP1dfr,
             *mPf,*mPfn,*mPfd,*Psdfpms,*r1image,*r2image,*r1sort,*r2sort,*tmPf,
             *tmPfn,*tmPfd,*topmid,*topsig,*scale;
   float     **AP1dfni,**AP1dfnn,**AP1dfnr,**AP1dfs,**AP1dfsp,**AP1dfu,
             **APsdfpm,**Psdfpms1, **Psdfpms2, **Psdfpms3, **Psdfpms4;

   // fftw
   rfftw_plan p;

   // datasec and biassec arrays
   int jj = 4;
   long dval[jj],bval[jj];

   // fitsio.h
   fitsfile *fptr_o,*tfptr_o;
            
   // cosmos.h
   fitsdef  fitsinfo;
   dewdat   indewinfo;

   // initialize
   nullval = 0;
   fpixel = 1;
   pnaxis = 1;
   
   // begin
   if(argc>1){
      strcpy(dfile,argv[1]);}
   else{
      printf("\nenter file to process: ");
      fgets(string,133,stdin);
      sscanf(string,"%s",dfile);}

   /*
   printf("%s\n",dfile);
   */

   datadir=malloc(sizeof(char)*80);
   datadir=getenv("COSMOS_IMAGE_DIR");
   if(datadir==NULL){
      printf("COSMOS_IMAGE_DIR undefined!\n");
      return 1;}
   strcat(datadir,"/");

   // get parameters
   if(OpenCosParm("ldss3-pattern")) die("Cannot open parameter file");
   if(ReadParm_s("dewar",indewar)==1) die("Parameter file error");
   if(ReadParm_i("top",&top)==1) die("Parameter file error");
   if(ReadParm_b("intermediate",&intermediate)==1) die("Parameter file error");
   if(ReadParm_i("iterations",&iter)==1) die("Parameter file error");
   scale = (float *) malloc(iter*sizeof(float));
   cut = (float *) malloc(iter*sizeof(float));
   for(m=0;m<iter;m++){
      sprintf(par,"scale%i",m+1);
      if(ReadParm_r(par,&scale[m])==1) die("Parameter file error");
      sprintf(par,"cut%i",m+1);
      if(ReadParm_r(par,&cut[m])==1) die("Parameter file error");
   }

   // get dewar information
   if(Readcdf(indewar)) die("Error reading dewar definition file");
   Getchipdat(&indewinfo);

   nchip = indewinfo.nchip;

   // pointers
   float     *AP1d0[nchip+1],*AP1dfd[nchip+1],*AP1dfp[nchip+1],*APsd0[nchip+1],
             *APsdfp[nchip+1],*AP1dfr[nchip+1],*AP1dfr1[nchip+1],
             *AP1dfr11[nchip+1],*AP1dfr2[nchip+1],*AP1dfw[nchip+1],
             *AP1dfw1[nchip+1],*bimage[nchip+1],*dbimage[nchip+1],
             *ddimage[nchip+1],*dimage[nchip+1],*DmPf1[nchip+1],*DmPf2[nchip+1],
             *image[nchip+1],*image_o[nchip+1],*mPf1[nchip+1],*mPf2[nchip+1],
             *pfilt[nchip+1],*tdiff[nchip+1],*tmPf1[nchip+1],*tmPf2[nchip+1],
             *tops1[nchip+1],*tops2[nchip+1];
   // fftw
   fftw_real *AP1d[nchip+1],*AP1df[nchip+1],*AP1dfn[nchip+1],*APf[nchip+1],
             *APsd[nchip+1], *APsdf[nchip+1];

   // fitsio.h
   fitsfile *fptr[nchip+1];

   for(i=1;i<=nchip;i++){
      strcpy(file,datadir);
      strcat(file,dfile);
      addbar(file);
      strcat(file,"c");
      sprintf(string,"%d.fits",i);
      strcat(file,string);
      //printf("Reading %s\n",file);
      printf("Read ccd chip %d\r",i);
      fflush(stdout);


      status=0;
      // open fits file
      fits_open_file(&fptr[i],file,READONLY,&status);
      if(status) fits_die(file,status);

      fits_get_hdu_num(fptr[i], &hdupos); 

      status=0;
      fits_get_img_param(fptr[i],2,&bitpix,&naxis,naxes,&status);

      nelem=naxes[0]*naxes[1];
      image[i] = (float *) malloc(nelem*sizeof(float));

      // read fits file
      status=0;
      fits_read_img(fptr[i],TFLOAT,fpixel,nelem,&nullval,image[i],&anynull,&status);
      fits_get_hdu_type(fptr[i], &hdutype, &status);

      // read fits header
      fits_read_key(fptr[i],TINT,"NOVERSCN",&overscan,line,&status);
      if(status) fits_die("Error reading fits header",status);  
      fits_read_key(fptr[i],TINT,"NBIASLNS",&biaslins,line,&status);
      if(status) fits_die("Error reading fits header",status);  
      fits_read_key(fptr[i],TSTRING,"BIASSEC",&biassec,line,&status);
      if(status) fits_die("Error reading fits header",status);  
      fits_read_key(fptr[i],TSTRING,"DATASEC",&datasec,line,&status);
      if(status) fits_die("Error reading fits header",status);  

      //datasec extrema
      fitssec(datasec,jj,dval);

      //biassec extrema
      fitssec(biassec,jj,bval);

      // setup for data with column bias
      /*
      printf("\n");
      printf("dval0 %i\n",dval[0]);
      printf("dval1 %i\n",dval[1]);
      printf("dval2 %i\n",dval[2]);
      printf("dval3 %i\n",dval[3]);
      printf("\n");
      printf("bval0 %i\n",bval[0]);
      printf("bval1 %i\n",bval[1]);
      printf("bval2 %i\n",bval[2]);
      printf("bval3 %i\n",bval[3]);
      printf("\n");
      */
      dnaxes[0] = naxes[0] - dval[0] + 1;
      dnaxes[1] = dval[3] - dval[2] + 1;
      dnelem = dnaxes[0] * dnaxes[1];
      dxmin = dval[0] - 1 ;
      dxmax = naxes[0];
      dymin = (dval[2] - 1) * naxes[0];
      dymax = dval[3] * naxes[0];

      /*
      printf("\n");
      printf("dnaxes0 %i\n",dnaxes[0]);
      printf("dnaxes1 %i\n",dnaxes[1]);
      printf("dnelem %i\n",dnelem);
      printf("dxmin %i\n",dxmin);
      printf("dxmax %i\n",dxmax);
      printf("dymin %i\n",dymin);
      printf("dymax %i\n",dymax);
      printf("\n");
      */

      // data with column bias
      dimage[i] = (float *) malloc(dnelem*sizeof(float));
      sub_img(image[i],dimage[i],nelem,dxmin,dxmax,dymin,dymax,naxes[0]); 
      // OUTPUT crap1_c?.fits
      /*
      sprintf(tfile_o,"!crap1_c%d.fits",i);
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,dnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,dnelem,dimage[i],&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */

      // setup for row bias with column bias
      bnaxes[0] = naxes[0];
      bnaxes[1] = overscan;
      bnelem = bnaxes[0] * bnaxes[1];
      bxmin = 0;
      bxmax = naxes[0];
      bymin = (naxes[1] - overscan) * naxes[0];
      bymax = naxes[1] * naxes[0];

      /*
      printf("\n");
      printf("bnaxes0 %i\n",bnaxes[0]);
      printf("bnaxes1 %i\n",bnaxes[1]);
      printf("bnelem %i\n",bnelem);
      printf("bxmin %i\n",bxmin);
      printf("bxmax %i\n",bxmax);
      printf("bymin %i\n",bymin);
      printf("bymax %i\n",bymax);
      printf("\n");
      */

      // row bias with column bias
      bimage[i] = (float *) malloc(bnelem*sizeof(float));
      sub_img(image[i],bimage[i],nelem,bxmin,bxmax,bymin,bymax,naxes[0]); 
      // OUTPUT crap2_c?.fits
      /*
      sprintf(tfile_o,"!crap2_c%d.fits",i);
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,bnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,bnelem,bimage[i],&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */

      // setup for column bias
      cnaxes[0] = bval[1] - bval[0] + 1;
      cnaxes[1] = bval[3] - bval[2] + 1;
      cnelem = cnaxes[0] * cnaxes[1];
      cxmin = bval[0] - 1 ;
      cxmax = bval[1];
      cymin = (bval[2] - 1) * naxes[0];
      cymax = bval[3] * naxes[0];

      // column bias
      cimage = (float *) malloc(cnelem*sizeof(float));
      sub_img(image[i],cimage,nelem,cxmin,cxmax,cymin,cymax,naxes[0]); 
      // OUTPUT crap3_c?.fits
      /*
      sprintf(tfile_o,"!crap3_c%d.fits",i);
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,cnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,cnelem,cimage,&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */

      // find median of column bias using qsort
      // and taking the average of the middle two numbers
      csort = (float *) malloc(cnelem*sizeof(float));
      for(k=0;k<cnelem;k++) csort[k]=cimage[k];
      free(cimage);

      qsort(csort, cnelem, sizeof(float), (void *)comp_nums);

      cnelem2 = cnelem/2;
      level = (csort[cnelem2] + csort[cnelem2+1])/2.0;
      free(csort);

      for(k=0;k<dnelem;k++) dimage[i][k] = dimage[i][k] - level;
      for(k=0;k<bnelem;k++) bimage[i][k] = bimage[i][k] - level;

      // setup for row bias 1
      r1naxes[0] = bnaxes[0] - biaslins;
      r1naxes[1] = overscan;
      r1nelem = r1naxes[0] * r1naxes[1];
      r1xmin = 0;
      r1xmax = bnaxes[0] - biaslins;
      r1ymin = (bnaxes[1] - overscan) * bnaxes[0];
      r1ymax = bnaxes[1] * bnaxes[0];

      // row bias 1
      r1image = (float *) malloc(r1nelem*sizeof(float));
      sub_img(bimage[i],r1image,bnelem,r1xmin,r1xmax,r1ymin,r1ymax,bnaxes[0]); 
      // OUTPUT crap4_c?.fits
      /*
      sprintf(tfile_o,"!crap4_c%d.fits",i);
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,r1naxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,r1nelem,r1image,&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */

      // find median of row bias 1 using qsort
      // and taking the average of the middle two numbers

      r1sort = (float *) malloc(r1nelem*sizeof(float));
      for(k=0;k<r1nelem;k++) r1sort[k]=r1image[k];
      free(r1image);

      qsort(r1sort, r1nelem, sizeof(float), (void *)comp_nums);

      r1nelem2 = r1nelem/2;
      levels1 = (r1sort[r1nelem2] + r1sort[r1nelem2+1])/2.0;
      free(r1sort);

      // setup for row bias 2
      r2naxes[0] = biaslins;
      r2naxes[1] = overscan;
      r2nelem = r2naxes[0] * r2naxes[1];
      r2xmin = dval[1];
      r2xmax = bnaxes[0];
      r2ymin = (bnaxes[1] - overscan) * bnaxes[0];
      r2ymax = bnaxes[1] * bnaxes[0];

      // row bias 2
      r2image = (float *) malloc(r2nelem*sizeof(float));
      sub_img(bimage[i],r2image,bnelem,r2xmin,r2xmax,r2ymin,r2ymax,bnaxes[0]); 
      // OUTPUT crap5_c?.fits
      /*
      sprintf(tfile_o,"!crap5_c%d.fits",i);
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,r2naxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,r2nelem,r2image,&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */

      // find median of row bias 1 using qsort
      // and taking the average of the middle two numbers

      r2sort = (float *) malloc(r2nelem*sizeof(float));
      for(k=0;k<r2nelem;k++) r2sort[k]=r2image[k];
      free(r2image);

      qsort(r2sort, r2nelem, sizeof(float), (void *)comp_nums);

      r2nelem2 = r2nelem/2;
      levels2 = (r2sort[r2nelem2] + r2sort[r2nelem2+1])/2.0;
      free(r2sort);

      // subtract column bias and row bias from data and row bias
      dbimage[i] = (float *) malloc(bnelem*sizeof(float));
      ddimage[i] = (float *) malloc(dnelem*sizeof(float));

      add_img(bimage[i],dbimage[i],-levels1,bnelem,r1xmin,r1xmax,bnaxes[0]); 
      add_img(dbimage[i],dbimage[i],-levels2,bnelem,r2xmin,r2xmax,bnaxes[0]); 
      add_img(dimage[i],ddimage[i],-levels1,dnelem,r1xmin,r1xmax,dnaxes[0]); 
      add_img(ddimage[i],ddimage[i],-levels2,dnelem,r2xmin,r2xmax,dnaxes[0]); 

      bitpix = -32;

      status=0;

      free(bimage[i]);
      free(dimage[i]);
   }
   printf("\n");

   product = 0;
   for(i=1;i<=nchip;i++){
      // inverted row bias
      mPf1[i] = (float *) malloc(bnelem*sizeof(float));
      for(k=0;k<bnelem;k++){
         mPf1[i][k] = f_divide_zero(1.0,dbimage[i][k],0.0);
      }
   }

   for(i=1;i<=nchip;i++){
      // inverted product row bias
      mPf2[i] = (float *) malloc(bnelem*sizeof(float));
      for(k=0;k<bnelem;k++){
         product = dbimage[i][k]*dbimage[i][k];
         mPf2[i][k] = f_divide_zero(1.0,product,0.0);
      }
   }
   for(i=1;i<=nchip;i++) free(dbimage[i]);

   mPfn = (float *) malloc(bnelem*sizeof(float));
   // numerator: sum of inverted row bias
   for(i=1;i<=nchip;i++){
      for(k=0;k<bnelem;k++){
         mPfn[k] = mPf1[i][k] + mPfn[k];
      }
   }

   mPfd = (float *) malloc(bnelem*sizeof(float));
   // denomenator: sum of inverted product row bias
   for(i=1;i<=nchip;i++){
      for(k=0;k<bnelem;k++){
         mPfd[k] = mPf2[i][k] + mPfd[k];
      }
   }

   mPf = (float *) malloc(bnelem*sizeof(float));
   // numerator divided by denomentator 
   for(k=0;k<bnelem;k++){
      mPf[k] = f_divide_zero(mPfn[k],mPfd[k],0.0);
   }

   if(intermediate){
      // OUTPUT ***SAVE*** pfilt.fits
      sprintf(tfile_o,"!pfilt_bias.fits");
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,naxis,bnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,bnelem,mPf,&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
   }

   for(i=1;i<=nchip;i++) free(mPf1[i]);
   for(i=1;i<=nchip;i++) free(mPf2[i]);
   free(mPfn);
   free(mPfd);


   /* NEED FIX FOR UNEVEN SIZE DATA SECTIONS */
   Anelem = dnaxes[0] * top;
   Aymin = (dnaxes[1] - top) * dnaxes[0];
   Aymax = dnaxes[1] * dnaxes[0];

   Anaxes[0] = dnaxes[0];
   Anaxes[1] = top;

   /*
   printf("\n");
   printf("Anaxes0 %i\n",Anaxes[0]);
   printf("Anaxes1 %i\n",Anaxes[1]);
   printf("Anelem %i\n",Anelem);
   printf("Aymin %i\n",Aymin);
   printf("Aymax %i\n",Aymax);
   printf("\n");
   */

   /*
   Two ways to deal with the cosmic rays:
   1. biweight
   2. median, 1.49*MAD
   */

   // Remove large cosmic rays
   for(i=1;i<=nchip;i++){
      m = 0;
      tops1[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<dnelem;k++){
         if(k >= Aymin && k < Aymax){
            tops1[i][m] = ddimage[i][k];
            m++; 
         }
      }
      if(intermediate){
         // OUTPUT ***SAVE*** top?.fits
         sprintf(tfile_o,"!top1_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,naxis,Anaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,Anelem,tops1[i],&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
   }

   product = 0;
   for(i=1;i<=nchip;i++){
      // inverted top of datasec
      tmPf1[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<Anelem;k++){
         tmPf1[i][k] = f_divide_zero(1.0,tops1[i][k],0.0);
      }
   }

   for(i=1;i<=nchip;i++){
      // inverted product top of datasec
      tmPf2[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<Anelem;k++){
         product = tops1[i][k]*tops1[i][k];
         tmPf2[i][k] = f_divide_zero(1.0,product,0.0);
      }
   }

   tmPfn = (float *) malloc(Anelem*sizeof(float));
   // numerator: sum of inverted top of datasec
   for(i=1;i<=nchip;i++){
      for(k=0;k<Anelem;k++){
         tmPfn[k] = tmPf1[i][k] + tmPfn[k];
      }
   }

   tmPfd = (float *) malloc(Anelem*sizeof(float));
   // denomenator: sum of inverted product top of datasec
   for(i=1;i<=nchip;i++){
      for(k=0;k<Anelem;k++){
         tmPfd[k] = tmPf2[i][k] + tmPfd[k];
      }
   }

   tmPf = (float *) malloc(Anelem*sizeof(float));
   // numerator divided by denomentator 
   for(k=0;k<Anelem;k++){
      tmPf[k] = f_divide_zero(tmPfn[k],tmPfd[k],0.0);
   }

   for(i=1;i<=nchip;i++) free(tmPf1[i]);
   for(i=1;i<=nchip;i++) free(tmPf2[i]);
   free(tmPfn);
   free(tmPfd);

   topmid = (float *) malloc(sizeof(float));
   topsig = (float *) malloc(sizeof(float));
   for(i=1;i<=nchip;i++){
      tdiff[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<Anelem;k++) tdiff[i][k] = tops1[i][k]-tmPf[k];
      biweight(tdiff[i],bwt,3,Anelem);
      topmid[i] = bwt[0];
      topsig[i] = bwt[1];
   }

   for(i=1;i<=nchip;i++){
      tops2[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<Anelem;k++){
         if (fabs(tops1[i][k]-tmPf[k]-topmid[i]) < 5*topsig[i]) {
            tops2[i][k] = tops1[i][k];
         } else {
            tops2[i][k] = tmPf[k]+topmid[i];
         }
      }
      if(intermediate){
         // OUTPUT ***SAVE*** top?.fits
         sprintf(tfile_o,"!top2_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,naxis,Anaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,Anelem,tops2[i],&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
   }
   free(tmPf);
   free(topmid);
   free(topsig);
   for(i=1;i<=nchip;i++) free(tops1[i]);

   for(i=1;i<=nchip;i++){
      APsd0[i] = (float *) malloc(Anelem*sizeof(float));
      for(k=0;k<Anelem;k++){
         APsd0[i][k] = tops2[i][k];
      }
   }
   for(i=1;i<=nchip;i++) free(tops2[i]);

   Anb2 = (long *) malloc((nchip+1) * sizeof(long));
   for(i=1;i<=nchip;i++){
      Anb2[i] = (long) powf(2,(long) (logf(Anelem)/logf(2)+1));
   }
   for(i=1;i<=nchip;i++){
      APsd[i] = (fftw_real *) malloc(Anb2[i]*sizeof(fftw_real));
   }
   for(i=1;i<=nchip;i++) {
      for(k=0;k<Anb2[i];k++){
         if(k < Anelem) APsd[i][k] = APsd0[i][k];
      }
   }
   for(i=1;i<=nchip;i++) free(APsd0[i]);

   for(i=1;i<=nchip;i++) {
      APsdf[i] = (fftw_real *) malloc(Anb2[i]*sizeof(fftw_real));
      p = rfftw_create_plan(Anb2[i], FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
      rfftw_one(p,APsd[i],APsdf[i]);
      rfftw_destroy_plan(p);
   }
   for(i=1;i<=nchip;i++) free(APsd[i]);

   for(i=1;i<=nchip;i++) {
      pnelem = Anb2[i]/2+1;
      pnaxes[0] = pnelem;
      APsdfp[i] = (float *) malloc(pnelem*sizeof(float));
      for(k=0;k < pnelem;k++){
         if(k!=0 && k!=pnelem-1){
            APsdfp[i][k] = sqrtf(powf(APsdf[i][k],2)+powf(APsdf[i][Anb2[i]-k],2));
         } else {
            APsdfp[i][k] = sqrtf(powf(APsdf[i][k],2));
         }
      }
      // OUTPUT ***SAVE*** powerl?.fits
      // VALUES ARE CHECK SLIGHTLY OFF
      // power spectrum
      if(intermediate){
         sprintf(tfile_o,"!powerl_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,APsdfp[i],&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
   }

   // FFT of data
   And2 = (long *) malloc((nchip+1) * sizeof(long));
   for(i=1;i<=nchip;i++){
      And2[i] = (long) powf(2,(long) (logf(dnelem)/logf(2)+1));
   }
   for(i=1;i<=nchip;i++){
      m = 0;
      AP1d0[i] = (float *) malloc(dnelem*sizeof(float));
      for(k=0;k<dnelem;k++){
         AP1d0[i][k] = ddimage[i][k];
      }
   }
   for(i=1;i<=nchip;i++) free(ddimage[i]);

   for(i=1;i<=nchip;i++){
      AP1d[i] = (fftw_real *) malloc(And2[i]*sizeof(fftw_real));
   }
   for(i=1;i<=nchip;i++) {
      for(k=0;k<And2[i];k++){
         if(k < dnelem) AP1d[i][k] = AP1d0[i][k];
      }
   }

   for(i=1;i<=nchip;i++) {
      AP1df[i] = (fftw_real *) malloc(And2[i]*sizeof(fftw_real));
      p = rfftw_create_plan(And2[i], FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
      rfftw_one(p,AP1d[i],AP1df[i]);
      rfftw_destroy_plan(p);
   }
   for(i=1;i<=nchip;i++) free(AP1d[i]);

   for(i=1;i<=nchip;i++) {
      pnelem = And2[i]/2+1;
      pnaxes[0] = pnelem;
      AP1dfp[i] = (float *) malloc(pnelem*sizeof(float));
      for(k=0;k < pnelem;k++){
         if(k!=0 && k!=pnelem-1){
            AP1dfp[i][k] = sqrtf(powf(AP1df[i][k],2)+powf(AP1df[i][And2[i]-k],2));
         } else {
            AP1dfp[i][k] = sqrtf(powf(AP1df[i][k],2));
         }
      }
      // OUTPUT ***SAVE*** power?.fits
      // VALUES ARE CHECK OUT
      // power spectrum
      if(intermediate){
         sprintf(tfile_o,"!power_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfp[i],&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
   }
   for(i=1;i<=nchip;i++) free(APsdf[i]);
   for(i=1;i<=nchip;i++) free(AP1d0[i]);

   Anmag = (float *) malloc((nchip+1)*sizeof(float));
   for(i=1;i<=nchip;i++) {
       Anmag[i] = (((float) And2[i])/2+1)/(((float) Anb2[i])/2+1);
   }
   free(Anb2);

   // Resampling of row bias
   APsdfpm = (float **) malloc((nchip+1) * sizeof(float*));
   for(i=1;i<=nchip;i++) {
      tnelem = And2[i]/2+1; // all elements
      pnelem = tnelem - (long) Anmag[i]; // elements interpolated
      APsdfpm[i] = (float *) malloc(tnelem*sizeof(float));
      u = 0;
      x1 = 0;
      for(v=0;v < pnelem;v++){
         // data coordinate system
         if(v > x1) u++;
         x0 = u*Anmag[i];
         x1 = (u+1)*Anmag[i];
         y0 = APsdfp[i][u];
         y1 = APsdfp[i][u+1];
         alpha = f_divide_zero(v-x0,x1-x0,0.0);
         y = y0+alpha*(y1-y0);
         z = y*sqrtf(Anmag[i]);        
         APsdfpm[i][v] = z;
      }
   }
   for(i=1;i<=nchip;i++) free(APsdfp[i]);

   // mirror the last elements
   for(i=1;i<=nchip;i++) {
      tnelem = And2[i]/2+1; // all elements
      pnelem = tnelem - (int) Anmag[i]; // elements interpolated
      l = 1;
      for(k=pnelem;k < tnelem;k++){
         APsdfpm[i][k] = APsdfpm[i][k-l];
         l = l + 2;
      }
   }
   free(Anmag);

   for(i=1;i<=nchip;i++) {
      pnelem = And2[i]/2+1;
      pnaxes[0] = pnelem;
      // OUTPUT ***SAVE*** powero?.fits
      // resampled power spectrum of row bias
      if(intermediate){
         sprintf(tfile_o,"!powero_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,APsdfpm[i],&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
   }

   AP1dfu = (float **) malloc((nchip+1) * sizeof(float*));
   for(i=1;i<=nchip;i++) {
      pnelem = And2[i]/2+1;
      AP1dfu[i] = (float *) malloc(pnelem*sizeof(float));
   }

   DmPf = (float *) malloc(dnelem*sizeof(float));

   // iterations
   for(m=0;m<iter;m++){
      printf("Pass %i\n",m+1);

      // OUTPUT powerm?.fits
      radius = (int) (3*scale[m]); // 3*sigma

      printf("Gaussian smoothing of absolute residuals with scale=%.1f\n",scale[m]);
      for(i=1;i<=nchip;i++) {

         pnelem = And2[i]/2+1;
         AP1dfw1[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            if(m==0){
               AP1dfw1[i][k] = f_divide_zero(1.,AP1dfp[i][k]*AP1dfp[i][k],0.0);
            } else {
               AP1dfw1[i][k] = f_divide_zero(AP1dfu[i][k],AP1dfp[i][k]*AP1dfp[i][k],0.0);
            }
         }
      }

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfd[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            AP1dfd[i][k] = AP1dfp[i][k]-APsdfpm[i][k];
         }

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfd_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfd[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfw[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            if(AP1dfd[i][k] <= 0.0) {
               r = 1.0;
            } else { 
               r = 0.0;
            }
            AP1dfw[i][k] = AP1dfw1[i][k]*r;
         }

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfw_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfw[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }
      for(i=1;i<=nchip;i++) free(AP1dfw1[i]);

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfr11[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
             AP1dfr11[i][k] = fabsf(AP1dfd[i][k])*AP1dfw[i][k];
         }

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfr11_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfr11[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }
      for(i=1;i<=nchip;i++) free(AP1dfd[i]);

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfr1[i] = (float *) malloc(pnelem*sizeof(float));
         //gauss(AP1dfr11[i],AP1dfr1[i],radius,scale[m],pnelem);
         gauss_fft(AP1dfr11[i],AP1dfr1[i],radius,scale[m],pnelem);

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfr1_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfr1[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }
      for(i=1;i<=nchip;i++) free(AP1dfr11[i]);

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfr2[i] = (float *) malloc(pnelem*sizeof(float));
         //gauss(AP1dfw[i],AP1dfr2[i],radius,scale[m],pnelem);
         gauss_fft(AP1dfw[i],AP1dfr2[i],radius,scale[m],pnelem);

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfr2_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfr2[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }
      for(i=1;i<=nchip;i++) free(AP1dfw[i]);

      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfr[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
             AP1dfr[i][k] = f_divide_zero(AP1dfr1[i][k],AP1dfr2[i][k],0.0)*1.25;
         }

         // OUTPUT ***SAVE*** powerr?.fits
         pnaxes[0] = pnelem;
         if(intermediate){
            sprintf(tfile_o,"!powerr_%d_c%d.fits",m+1,i);
            fits_create_file(&tfptr_o,tfile_o,&status);
            fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
            fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfr[i],&status);
            fits_get_errstatus(status,line);
            printf("Writing file %s\n",tfile_o);
            status=0;
            fits_close_file(tfptr_o,&status);
         }
      }
      for(i=1;i<=nchip;i++) free(AP1dfr1[i]);
      for(i=1;i<=nchip;i++) free(AP1dfr2[i]);

      // minimum
      qnelem = And2[1]/2+1;
      mP1dfr = (float *) malloc(qnelem*sizeof(float));
      for(k=0;k < qnelem;k++){
         mmP1dfr = 1.0*pow(10,30);
         for(i=1;i<=nchip;i++){ 
             if(AP1dfr[i][k] < mmP1dfr) mmP1dfr = AP1dfr[i][k];
         }
         mP1dfr[k] = mmP1dfr;
      }
      for(i=1;i<=nchip;i++) free(AP1dfr[i]);

      /*
      pnaxes[0] = pnelem;
      sprintf(tfile_o,"!mP1dfr.fits");
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,mP1dfr,&status);
      fits_get_errstatus(status,line);
      printf("%i - %s: %s\n\n",status,line,tfile_o);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */


      Psdfpms1 = (float **) malloc((nchip+1) * sizeof(float*));
      Psdfpms2 = (float **) malloc((nchip+1) * sizeof(float*));
      Psdfpms3 = (float **) malloc((nchip+1) * sizeof(float*));
      Psdfpms4 = (float **) malloc((nchip+1) * sizeof(float*));
      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         Psdfpms1[i] = (float *) malloc(pnelem*sizeof(float));
         Psdfpms2[i] = (float *) malloc(pnelem*sizeof(float));
         Psdfpms3[i] = (float *) malloc(pnelem*sizeof(float));
         Psdfpms4[i] = (float *) malloc(pnelem*sizeof(float));
         //gauss(APsdfpm[i],Psdfpms1[i],radius,scale[m],pnelem);
         gauss_fft(APsdfpm[i],Psdfpms1[i],radius,scale[m],pnelem);

         for(k=0;k < pnelem;k++){
            Psdfpms2[i][k] = fabsf(APsdfpm[i][k]-Psdfpms1[i][k]);
         }

         //gauss(Psdfpms2[i],Psdfpms3[i],radius,scale[m],pnelem);
         gauss_fft(Psdfpms2[i],Psdfpms3[i],radius,scale[m],pnelem);

         for(k=0;k < pnelem;k++){
            Psdfpms4[i][k] = Psdfpms3[i][k]*1.25;
         }

         free(Psdfpms1[i]);
         free(Psdfpms2[i]);
         free(Psdfpms3[i]);
      }

      // mean
      Psdfpms = (float *) malloc(qnelem*sizeof(float));
      for(k=0;k < qnelem;k++){
         mPsdfpms = 0.0;
         for(i=1;i<=nchip;i++) mPsdfpms = mPsdfpms + Psdfpms4[i][k];
         Psdfpms[k] = mPsdfpms / nchip;
      }
      for(i=1;i<=nchip;i++) free(Psdfpms4[i]);

      /*
      pnaxes[0] = pnelem;
      sprintf(tfile_o,"!Psdfpms.fits");
      fits_create_file(&tfptr_o,tfile_o,&status);
      fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
      fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,Psdfpms,&status);
      fits_get_errstatus(status,line);
      printf("%i - %s: %s\n\n",status,line,tfile_o);
      printf("Writing file %s\n",tfile_o);
      status=0;
      fits_close_file(tfptr_o,&status);
      */
 
      // sqrt
      AP1dfr3 = (float *) malloc(qnelem*sizeof(float));
      for(k=0;k < qnelem;k++){
         AP1dfr3[k] = sqrtf(powf(mP1dfr[k],2)+powf(Psdfpms[k],2));
      }

      // OUTPUT ***SAVE*** powerr?.fits
      if(intermediate){
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!powerr_%d.fits",m+1);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfr3,&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }

      free(mP1dfr);
      free(Psdfpms);


      printf("Clipping\n");

      AP1dfs = (float **) malloc((nchip+1) * sizeof(float*));
      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         AP1dfs[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            AP1dfs[i][k] = f_divide_zero(AP1dfp[i][k]-APsdfpm[i][k],AP1dfr3[k],0.0);
         }

         /*
         pnaxes[0] = pnelem;
         sprintf(tfile_o,"!AP1dfs_c%d.fits",i);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfs[i],&status);
         fits_get_errstatus(status,line);
         printf("%i - %s: %s\n\n",status,line,tfile_o);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
         */
      }

      free(AP1dfr3);

      AP1dfsp = (float **) malloc((nchip+1) * sizeof(float*));
      printf("Cutting at %.1f\n",cut[m]);
      for(i=1;i<=nchip;i++) {
         ncut = 0;
         pnelem = And2[i]/2+1;
         AP1dfsp[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            if(AP1dfs[i][k] <= cut[m]) {
               r = 1.0;
            } else { 
               r = 0.0;
               ncut += 1;
            }
            AP1dfu[i][k] = r;
         }
         printf("Number clipped out was %d.\n",ncut);

         // OUTPUT ***SAVE*** poweru?.fits
         if(intermediate){
            pnaxes[0] = pnelem;
            sprintf(tfile_o,"!poweru_%d_c%d.fits",m+1,i);
            fits_create_file(&tfptr_o,tfile_o,&status);
            fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
            fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfu[i],&status);
            fits_get_errstatus(status,line);
            printf("Writing file %s\n",tfile_o);
            status=0;
            fits_close_file(tfptr_o,&status);
         }

         for(k=0;k < pnelem;k++){
            AP1dfsp[i][k] = AP1dfu[i][k]*AP1dfp[i][k];
         }

         // OUTPUT ***SAVE*** powerc?.fits
         if(intermediate){
            pnaxes[0] = pnelem;
            sprintf(tfile_o,"!powerc_%d_c%d.fits",m+1,i);
            fits_create_file(&tfptr_o,tfile_o,&status);
            fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
            fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfsp[i],&status);
            fits_get_errstatus(status,line);
            printf("Writing file %s\n",tfile_o);
            status=0;
            fits_close_file(tfptr_o,&status);
         }

      }

      free(AP1dfs);
      free(AP1dfsp);

      // real and imaginary arrays
      AP1dfnr = (float **) malloc((nchip+1) * sizeof(float*));
      AP1dfni = (float **) malloc((nchip+1) * sizeof(float*));
      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         pnaxes[0] = pnelem;
         AP1dfnr[i] = (float *) malloc(pnelem*sizeof(float));
         AP1dfni[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            AP1dfnr[i][k] = AP1df[i][k]*AP1dfu[i][k];
            if(k!=0 && k!=pnelem-1){
               AP1dfni[i][k] = AP1df[i][And2[i]-k]*AP1dfu[i][k];
            } else {
               AP1dfni[i][k] = 0.0;
            }
         }
      }

      // FFT Inverse
      for(i=1;i<=nchip;i++) AP1dfn[i] = (fftw_real *) malloc(And2[i]*sizeof(fftw_real));

      for(i=1;i<=nchip;i++) {
         //printf("\nChip %i\n",i);
         for(k=0;k<And2[i];k++){
            if(k < And2[i]/2+1) {
               AP1dfn[i][k] = AP1dfnr[i][k];
            } else if(k >= And2[i]/2+1 && k < And2[i]){
               AP1dfn[i][k] = AP1dfni[i][And2[i]-k];
            }

         }
      }
      free(AP1dfni);
      free(AP1dfnr);

      AP1dfnn = (float **) malloc((nchip+1) * sizeof(float*));
      for(i=1;i<=nchip;i++) {
         pnelem = And2[i]/2+1;
         pnaxes[0] = pnelem;
         AP1dfnn[i] = (float *) malloc(pnelem*sizeof(float));
         for(k=0;k < pnelem;k++){
            if(k!=0 && k!=pnelem-1){
               AP1dfnn[i][k] = sqrtf(powf(AP1dfn[i][k],2)+powf(AP1dfn[i][And2[i]-k],2));
            } else {
               AP1dfnn[i][k] = sqrtf(powf(AP1dfn[i][k],2));
            }
         }
         // OUTPUT ***SAVE*** powerf?.fits
         // VALUES ARE CHECK OUT
         // power spectrum
         if(intermediate){
            sprintf(tfile_o,"!powerf_%d_c%d.fits",m+1,i);
            fits_create_file(&tfptr_o,tfile_o,&status);
            fits_create_img(tfptr_o,bitpix,pnaxis,pnaxes,&status);
            fits_write_img(tfptr_o,TFLOAT,fpixel,pnelem,AP1dfnn[i],&status);
            fits_get_errstatus(status,line);
            printf("Writing file %s\n",tfile_o);
            status=0;
            fits_close_file(tfptr_o,&status);
         }
      }
      free(AP1dfnn);

      for(i=1;i<=nchip;i++) {
         APf[i] = (fftw_real *) malloc(And2[i]*sizeof(fftw_real));
         pfilt[i] = (float *) malloc(dnelem*sizeof(float));
         p = rfftw_create_plan(And2[i], FFTW_COMPLEX_TO_REAL, FFTW_ESTIMATE);
         rfftw_one(p,AP1dfn[i],APf[i]);
         rfftw_destroy_plan(p);
         // FFTW_COMPLEX_TO_REAL needs to be renormalized
         for(k=0;k<dnelem;k++) pfilt[i][k] = APf[i][k]/And2[i];
      }

      for(i=1;i<=nchip;i++) free(AP1dfn[i]);
      for(i=1;i<=nchip;i++) free(APf[i]);

      for(i=1;i<=nchip;i++) {
         // OUTPUT ***SAVE*** pfilt_c?.fits
         if(intermediate){
            sprintf(tfile_o,"!pfilt_%d_c%d.fits",m+1,i);
            fits_create_file(&tfptr_o,tfile_o,&status);
            fits_create_img(tfptr_o,bitpix,naxis,dnaxes,&status);
            fits_write_img(tfptr_o,TFLOAT,fpixel,dnelem,pfilt[i],&status);
            fits_get_errstatus(status,line);
            printf("Writing file %s\n",tfile_o);
            status=0;
            fits_close_file(tfptr_o,&status);
         }
      }

      for(i=1;i<=nchip;i++){
         DmPf1[i] = (float *) malloc(dnelem*sizeof(float));
         for(k=0;k<dnelem;k++){
            DmPf1[i][k] = f_divide_zero(1.0,pfilt[i][k],0.0);
         }
      }
   
      product = 0;
      for(i=1;i<=nchip;i++){
         DmPf2[i] = (float *) malloc(dnelem*sizeof(float));
         for(k=0;k<dnelem;k++){
            product = pfilt[i][k]*pfilt[i][k];
            DmPf2[i][k] = f_divide_zero(1.0,product,0.0);
         }
      }
      for(i=1;i<=nchip;i++) free(pfilt[i]);
   
      DmPfn = (float *) malloc(dnelem*sizeof(float));
      for(i=1;i<=nchip;i++){
         for(k=0;k<dnelem;k++){
            DmPfn[k] = DmPf1[i][k] + DmPfn[k];
         }
      }
   
      DmPfd = (float *) malloc(dnelem*sizeof(float));
      for(i=1;i<=nchip;i++){
         for(k=0;k<dnelem;k++){
            DmPfd[k] = DmPf2[i][k] + DmPfd[k];
         }
      }
   

      // numerator divided by denomentator 
      for(k=0;k<dnelem;k++){
         DmPf[k] = f_divide_zero(DmPfn[k],DmPfd[k],0.0);
      }

      for(i=1;i<=nchip;i++) free(DmPf1[i]);
      for(i=1;i<=nchip;i++) free(DmPf2[i]);
      free(DmPfn);
      free(DmPfd);

      // OUTPUT ***SAVE*** pfilt.fits
      if(intermediate){
         sprintf(tfile_o,"!pfilt_%d.fits",m+1);
         fits_create_file(&tfptr_o,tfile_o,&status);
         fits_create_img(tfptr_o,bitpix,naxis,dnaxes,&status);
         fits_write_img(tfptr_o,TFLOAT,fpixel,dnelem,DmPf,&status);
         fits_get_errstatus(status,line);
         printf("Writing file %s\n",tfile_o);
         status=0;
         fits_close_file(tfptr_o,&status);
      }
         
   }
   free(And2);
   free(AP1dfu);
   free(APsdfpm);
   for(i=1;i<=nchip;i++) free(AP1dfp[i]);
   for(i=1;i<=nchip;i++) free(AP1df[i]);

   n = 0;
   for(i=1;i<=nchip;i++){
      image_o[i] = (float *) malloc(nelem*sizeof(float));
      for(k=0;k<nelem;k++){
         if(k >= bymin && k < bymax){
            // row bias
            if(n >= bxmin && n < bxmax){
               image_o[i][k] = image[i][k] - mPf[k-bymin];
            }
         } else if(k >= dymin && k < dymax){
            // data
            if(n >= dxmin && n < dxmax){
               image_o[i][k] = image[i][k] - DmPf[k-dymin];
            }
         } else {
            // other
            image_o[i][k] = image[i][k];
         }
         n++;
         if(n == naxes[0]) n = 0;
      }
   
      strcpy(file_o,"!");
      strcat(file_o,datadir);
      strcat(file_o,dfile);
      strcat(file_o,"ff");
      strcat(file_o,"c");
      sprintf(string,"%d.fits",i);
      strcat(file_o,string);
      fits_create_file(&fptr_o,file_o,&status);
      fits_create_img(fptr_o,bitpix,naxis,naxes,&status);

      // Useful function from fitsio example imcopy.c
      fits_get_hdrspace(fptr[i], &nkeys, NULL, &status);

      for(m=0;m<iter;m++){
         sprintf(key,"SCALE%i",m+1);
         fits_write_key(fptr_o,TFLOAT,key,&scale[m],"pattern noise smoothing",
                        &status);
         sprintf(key,"CUT%i",m+1);
         fits_write_key(fptr_o,TFLOAT,key,&cut[m],"pattern noise clipping",
                        &status);
      }

      for (j = 1; j <= nkeys; j++) {
          fits_read_record(fptr[i], j, card, &status);
          if (fits_get_keyclass(card) > TYP_CMPRS_KEY)
              fits_write_record(fptr_o, card, &status);
      }

      fits_write_img(fptr_o,TFLOAT,fpixel,nelem,image_o[i],&status);
      fits_get_errstatus(status,line);
      printf("Writing file %s\n",file_o);
      status=0;
      fits_close_file(fptr_o,&status);
   }
   for(i=1;i<=nchip;i++) fits_close_file(fptr[i],&status);
   free(DmPf);
   free(mPf);
   for(i=1;i<=nchip;i++) free(image[i]);
   for(i=1;i<=nchip;i++) free(image_o[i]);
   free(scale);
   free(cut);

   //
   // Gaussian smoothing example 
   //

   /*
   //float array1[] = {0,1,2,3,4,5,4,3,2,1,0,1,2,3,4,5,4,3,2,1,0,1,2,3,4,5};
   float array1[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25};
   float *array2;
   int radius = 3;
   float sigma = 1.0;
   long elm = 26;
   array2 = (float *) malloc(elm*sizeof(float));
   gauss(array1,array2,radius,sigma,elm);
   for(k=0;k <= elm-(2*radius+1);k++) printf("%i %f\n",k,array2[k]);
   */

   /*  Working Example of FFTW
   int N = 100;
   fftw_real in[N], out[N];
   rfftw_plan p;

   for(k=0;k<N;k++) in[k] = 0.0;

   p = rfftw_create_plan(N, FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
   rfftw_one(p,in,out);
   rfftw_destroy_plan(p);
  
   for(k=0;k<N;k++) printf("%f\n",out[k]);
   */

   return 0;
}

// functions
void fitssec(char *sec, int ii, long *val){
   int j;
   char* secstr = strtok(sec,DELIMITERS);
   val[0] = atol(secstr);

   for(j=1;j<ii;j++){
      secstr = strtok(NULL,DELIMITERS);
      val[j] = atol(secstr);
   }
   return;
}

void sub_img(float *image, float *image_o, long nelem, long x0, long x1, 
             long y0, long y1, long x){
   int k,l,m;
   l = 0; 
   m = 0;
   for(k=0;k<nelem;k++){
      if(k >= y0 && k < y1){
         if(m >= x0 && m < x1){
            image_o[l] = image[k];
            l++;
         } 
         m++;
         if(m == x) m = 0;
      }
   }
}

// To subtract: place a negative sign in front of value
void add_img(float *image, float *image_o, float value, long nelem, long x0, 
             long x1, long x){
   int k,m;
   m = 0;
   for(k=0;k<nelem;k++){
      if(m >= x0 && m < x1){
         image_o[k] = image[k] + value;
      } else {
         image_o[k] = image[k];
      }
      m++;
      if(m == x) m = 0;
   }
}

int comp_nums(const float *num1, const float *num2)
{
   if (*num1 <  *num2) return -1;
   if (*num1 == *num2) return  0;
   if (*num1 >  *num2) return  1;
}

float f_divide_zero(float x, float y, float repl){
   if(y == 0.0){
      return repl;
   } else {
      return x/y;
   }
}

void gauss(float *array, float *array_o, int radius, float sigma, long nelem){
   float *G;
   float norm;
   int r,x,i,y;
   float o,relem;
   relem = 2*radius+1;
   G = (float *) malloc(relem*sizeof(float));
   norm = 1./(sqrtf(2.*M_PI)*sigma);
   for(r=-radius;r<=radius;r++){
       G[r+radius] = norm*expf(-0.5*powf(r,2.)/powf(sigma,2.));
   }

   for(x=0;x<nelem;x++){
      o = 0.0;
      for(r=-radius;r<=radius;r++) {
        if (x+r>= 0 && x+r<nelem) o += (array[x+r]*G[r+radius]);
      }
      array_o[x] = o;
   }
   free(G);
}

void gauss_fft(float *array, float *array_o, int radius, float sigma,
               long nelem){

   int i;
   float w, *ff3, ff3e;
   long n2, n3;
   fftw_real *ff1, *g, *o, *z;
   rfftw_plan p;

   n2 = (long) powf(2,(long) (logf(nelem - 1)/logf(2)+1));
   n3 = n2/2+1;

   z = (fftw_real *) malloc(n2*sizeof(fftw_real));
   for(i=0;i<nelem;i++){
      z[i] = array[i];
   }

   ff1 = (fftw_real *) malloc(n2*sizeof(fftw_real));
   p = rfftw_create_plan(n2, FFTW_REAL_TO_COMPLEX, FFTW_ESTIMATE);
   rfftw_one(p,z,ff1);
   rfftw_destroy_plan(p);
   free(z);

   ff3 = (float *) malloc(n3*sizeof(float));
   for(i=0;i<n3;i++){
      w = 2.*M_PI*i*sigma/(n2/2.);
      ff3[i] = expf(-1*powf(w,2)/2);
   }

   o = (fftw_real *) malloc(n2*sizeof(fftw_real));
   for(i=0;i<n2;i++){
      if(i < n3) {
         o[i] = ff1[i]*ff3[i];
      } else if(i >= n3 && i < n2){
         o[i] = ff1[i]*ff3[n2-1-i];
      }

   }
   free(ff1);
   free(ff3);

   g = (fftw_real *) malloc(n2*sizeof(fftw_real));
   p = rfftw_create_plan(n2, FFTW_COMPLEX_TO_REAL, FFTW_ESTIMATE);
   rfftw_one(p,o,g);
   rfftw_destroy_plan(p);
   free(o);

   for(i=0;i<nelem;i++){
      // FFTW_COMPLEX_TO_REAL needs to be renormalized
      array_o[i] = g[i]/n2;
   }
   free(g);
}

float median(float *array, long nelem) {
   float *asort;
   float x;
   int k;
   asort = (float *) malloc(nelem*sizeof(float));
   for(k=0;k<nelem;k++) asort[k]=array[k];
   qsort(asort, nelem, sizeof(float), (void *)comp_nums);
   if (nelem % 2 == 0) {
      x = (asort[nelem/2] + asort[nelem/2+1])/2.0;
   } else {
      x = asort[nelem/2+1];
   }
   free(asort);
   return x;
}

void biweight(float *array, float *array_o, int iter, long nelem) {
   int j,k;
   float M = median(array,nelem);

   float *D;
   D = (float *) malloc(nelem*sizeof(float));
   for(j=0;j<nelem;j++){
      D[j] = fabs(array[j] - M);
   }
   float MAD = median(D,nelem);
   free(D);

   float C6,D6,C91,C92,c6,d,u6,u9,g6,g9,S;
   if(MAD) {
      for(k=0;k<iter;k++){
         C6 = 0;
         D6 = 0;
         C91 = 0;
         C92 = 0;
         for(j=0;j<nelem;j++){
            d = array[j] - M;
            u6 = f_divide_zero(d,MAD,0.0)/6.0;
            g6 = fabs(u6);
            // Less function
            if ( g6 < 1.0) {
               g6 = 1.0;
            } else {
               g6 = 0.0;
            }
            c6 = powf(1-powf(u6,2),2)*g6;
            C6 = C6 + c6;
            D6 = D6 + d*c6;
         } 
         M = M + D6/C6;
         for(j=0;j<nelem;j++){
            d = array[j] - M;
            u9 = f_divide_zero(d,MAD,0.0)/9.0;
            g9 = fabs(u9);
            // Less function
            if ( g9 < 1.0) {
               g9 = 1.0;
            } else {
               g9 = 0.0;
            }
            C91 = C91 + powf(d,2)*powf(1-powf(u9,2),4)*g9;
            C92 = C92 + (1-powf(u9,2))*(1-5*powf(u9,2))*g9;
         }
         S = sqrtf(nelem) * f_divide_zero(sqrtf(C91),fabs(C92),0.0);
         MAD = S*0.6745;
      }
   }

   array_o[0] = M;
   array_o[1] = S;
}
