/*****************************************************************************\
*                                                                             *
*  MAP_SPECTRA  produces parameter files to be used to map spectra produced   *
*               by a mask/observation combination onto the ccd's. Parameter   *
*               files are input to sky subtraction, wavelength fitting, and   *
*               spectrum extraction programs                                  *
*                                                                             *
*               N.B.                                                          *
*                                                                             *
*   VERSION  19 Mar 2005                                                      *
*                                                                             *
*   USAGE:   map-spectra obsname                                              *
\*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "ioutils.h"
#include "kdcutil.h"
#include "mgutils.h"
#include "optutils.h"
#include "cosmos.h"
#include "clardy.h"

int  main(int argc,char *argv[]){

  Obs     *obset = NULL;
  element *optics, *instrument, *p;
  vect3   mskpos,campos,cenpos,objpos;
  vect2   mpl,mpleft,mpright,mpdif,mpcen,ldif,rdif,mpdelt;
  double  cur_wavl, cur_temp;
  int     i,j,gr_order,chip,curslit,minpixl,nchip,xchip,ychip,xdisper,npxl,
          npx,nbd,lastchip,chip1,order,ind,dorder,corder,*ip,ord_disper,
          ord_sag,nchp,ord_tilt,ord_sagit,ord_slen,maxord,mesage,fsln,nval,
          badnum[1000],useaps,useprtl,prtl,chipnum;
  float   gr_angle,xccd,yccd,xfp,yfp,xlfp,ylfp,lambda,lambda0,lambda1,dlambda1,
          telscale,temp,slitobj,slittop,slitbot,sltp,curvx,meanl,xccd1,
          yccd1,disper,camscale,slitleft,slitright,lamin,lamax,mplft,mprt,
          coefs[12],slitmin,slitmax,slitmean,leftpos,rightpos,midpos,centr,
          xcd,ycd,xlcd,ylcd,slitln,xl,xr,yl,yr,stdev,dmean;
  float  *xval,*yval,*lamval,*tilt,*sagit,*slitlen;
  double   *xlist,*ylist,**elist,maskang,xx;
  char    **badname,*CHARP;
  char    cmra,flnm[80],file[80],maskfile[80],INSTRMNT[80],GRATNG[80],
          CHAR,SMF_FILE[80],camdef[80],camoff[80],imacsdir[80];
  slit    slitdat;
  objq    *oq, *oq1;
  obsdef  obsdata;
  objdat  objdata;
  dewdat  dewinfo;
  FILE    *infile,*outfile,*curvfile;

  float   pixint=3.;//fitting interval in pixels
  telscale=2.899;
  nbd=0;
  
  //order of fits
  ord_disper=7;
  ord_sag=5;
  ord_tilt=5;
  ord_sagit=5;
  ord_slen=5;
  

  /*------------------------get observ data----------------------------------*/

  //prompt for parameters
  if(argc<2){
    while(1){
      printf("Enter observation name: ");
      scanf("%s",maskfile);
      if(ReadObsDef(maskfile,&obsdata)==0) break;
      printf("Cannot open observation definition file!\n");}
    }
  //parameters on commancd line
  else{
    sscanf(argv[1],"%s",maskfile);
    if(ReadObsDef(maskfile,&obsdata)!=0)
      {printf("%Cannot open observation definition file!\n");}
    }


 
  strcpy(file,"map-spectra");
  if(OpenCosParm(file)!=0) die("Cannot open map-spectra parameter file");
  if(ReadParm_r("minlambda",&lambda0)==1) die("parameter file error");
  if(ReadParm_r("maxlambda",&lambda1)==1)die("parameter file error");
  if(ReadParm_i("minpixl",&minpixl)==1) die("parameter file error");
  minpixl/=pixint;
  if(ReadParm_b("use_holes",&useaps)==1) die("parameter file error");
  if(ReadParm_i("chipnum",&chipnum)==1) die("parameter file error");
  if(ReadParm_b("partials",&useprtl)==1) useprtl=0;

  /*------------------------- get mask data--------------------------------- */
  
  strcpy(flnm,obsdata.mask);
  strcpy(SMF_FILE,flnm);
  strcat(SMF_FILE,".SMF");
  if(ReadSMFfile(SMF_FILE,&obset)) return 1;
  cur_temp=obset->temp;
  
  //read obsservation data
  
  if(!strcmp(obsdata.mode,"DIRECT")){
    printf("map-spectra requires a spectroscopic image\n");
    return 1;}
  SetupInstr(&obsdata,&instrument);
  if(SetupCamera(obsdata)==1) return 1;
  
  /*----------- get CCD parmaeters and mapping -----------------------------*/
  
  Getchipdat(&dewinfo);
  
  /*--------------------------setup  arrays_______________________________*/

  maxord=ord_disper;
  maxord = (ord_sag>maxord) ? ord_sag: maxord;
  maxord = (ord_sagit>maxord) ? ord_sagit: maxord;
  maxord = (ord_tilt>maxord) ? ord_tilt: maxord;
  maxord+=1;
  xlist=malloc(sizeof(xx)*2*maxord);                                 
  ylist=malloc(sizeof(xx)*maxord);                                
  elist=malloc(sizeof(xlist)*maxord);                         
  for(i=0;i<maxord;i++){
    *(elist+i)=malloc(sizeof(xx)*(maxord+1));}
  //  nval=(lambda1-lambda0)/disper+10;
  nval=10000;
  xval=malloc(sizeof(xx)*nval);
  yval=malloc(sizeof(xx)*nval);
  tilt=malloc(sizeof(xx)*nval);
  sagit=malloc(sizeof(xx)*nval);
  lamval=malloc(sizeof(xx)*nval);
  slitlen=malloc(sizeof(xx)*nval);
  badname=malloc(sizeof(CHARP)*1000);
  for(i=0;i<1000;i++) *(badname+i)=malloc(sizeof(CHAR)*20);

  /*----------------------determine slit scale, dispersion___________________*/
  oq=obset->ob;
  oq1=oq;
  meanl=(lambda0+lambda1)/2.;
  dmean=(lambda1/lambda0)/10.;
  while(1){
    mskpos = get3de2v(oq->smpos,0.0);
    cur_wavl=meanl;
    campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
    xfp=campos.x;
    yfp=campos.y;
    chip1=fp2ccd(xfp,yfp,&xccd1,&yccd1,cur_wavl);
    if(!chip1) goto C;
    cur_wavl+=1.;
    campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
    xfp=campos.x;
    yfp=campos.y;
    chip=fp2ccd(xfp,yfp,&xccd,&yccd,cur_wavl);
    if(chip != chip1) goto C;
    //along which axis does dispersion run?
    xdisper=0;
    if(fabs((double)((xccd-xccd1)/(yccd-yccd1))) > 1.) xdisper=1;
    if(xdisper) disper=fabs(pixint/(double)(xccd-xccd1));
    else disper=fabs(pixint/(double)(yccd-yccd1));
    //what is camera demagnification,handedness?
    mskpos.x+=1;
    mskpos.y+=1.;
    campos = Op_transform(mskpos,instrument,cur_wavl,cur_temp);
    xfp=campos.x;
    yfp=campos.y;
    chip1=fp2ccd(xfp,yfp,&xccd1,&yccd1,cur_wavl);
    if(chip != chip1) goto C;
    if(xdisper) camscale=fabs((double)(yccd-yccd1));
    else camscale=fabs((double)(xccd-xccd1));
    if(!strcasecmp(obsdata.camera,"LONG")) camscale=-camscale;
    break;
C:  oq=oq->next;
    if(oq==oq1){                            //haven't found a line within image
      meanl+=dmean;                         //change wavelength
      if(meanl>lambda0 && meanl<lambda1) continue;
      if(meanl>lambda1){          //hit upper wavelength, go in other direction
        dmean=-dmean;
        meanl=(lambda0+lambda1)/2.+dmean;
        continue;}
      die("Cannot map slits");}
  }
  strcpy(file,maskfile);
  strcat(file,".map");
  outfile=fopen(file,"w");
  fprintf(outfile,"Xdispersion =  %d\nFit orders = %d %d %d %d %d\n",xdisper,
          ord_disper,ord_sag,ord_tilt,ord_sagit,ord_slen);
  fprintf(outfile,"Scale ~ %10.4f Camscale = %8.3f\nLambda  = %7.1f %7.1f\n",telscale,camscale,lambda0,
          lambda1);
//  fprintf(outfile,"Dewar = %s %d\n\n",obsdata.dewar,dewinfo.nchip);
  fprintf(outfile,"Dewar = %s %d\n\n",obsdata.dewar,chipnum);

  /*------------------------ map slits --------------------------------------*/
      
  oq=oq1;
  curslit=1;
  mesage=0;
  //loop over all slits
  while(1){
    printf("Processing slit %d\r",curslit);
    nchp=0;
    slitdat=oq->slit;
    objdata=oq->dat;
    if(slitdat.shape !=2 && !useaps){
      oq=oq->next;
      mesage=0;
      printf("skipping aperture before slit %d\n",curslit);
      if(oq==oq1) break;
      continue;}
    fflush(stdout);
    strcpy(*(badname+nbd),objdata.name);
    badnum[nbd]=curslit;
    objpos=get3de2v(oq->smpos,0.0);
    fprintf(outfile,"SLIT %d %s %d\n",curslit,objdata.name,slitdat.shape);
	  mpleft=sum2vect(oq->smpos,lslit(oq->slit));
	  mpright=sum2vect(oq->smpos,rslit(oq->slit));
    ldif=lslit(oq->slit);
    rdif=rslit(oq->slit);
    mpdif=sum2vect(ldif,rdif);
    mpdelt=mul2vect(mpdif,0.5);
	  mpcen=sum2vect(oq->smpos,mpdelt);
	  cenpos=get3de2v(mpcen,0.0);
    

    //slitends

    /*----------------trace spectrum, slit curvature-------------------------*/
    
    lambda=lambda0-disper;;
    fsln=0;
    prtl=0;
    while(lambda<lambda1+disper){
      lambda+=disper;
      npxl=0;
      lastchip=0;
      //loop while on one chip
      while(1){
	campos = Op_transform(objpos,instrument,lambda,cur_temp);
	xfp=campos.x;
	yfp=campos.y;
	chip=fp2ccd(xfp,yfp,&xccd,&yccd,lambda);
	if(chip<1 || lambda>lambda1 || (chip!=lastchip && npxl)) break;
	if(!npxl){
	  lamin=lambda;}
	  //get ends of slit
	  //object
	  slitobj= (xdisper) ? yccd: xccd;
	  //"left"=minvalue slit end
	  xl=mpleft.x;
	  yl=mpleft.y;
	  mskpos = get3de2v(mpleft,0.0);
	  campos = Op_transform(mskpos,instrument,lambda,cur_temp);
	  xlfp=campos.x;
	  ylfp=campos.y;
	  //printf("%d %f %f\n",slit,xfp,yfp);
	  chip1=fp2ccd(xlfp,ylfp,&xlcd,&ylcd,lambda);
    //does spectrum straddle 2 chips?
    if(abs(chip) != abs(chip1)) break;
    if(chip1<0){
      if(!useprtl) break;
      if(xdisper && (xlcd<0 || xlcd>dewinfo.xchip-1)) break;
      if(!xdisper && (ylcd<0 || ylcd>dewinfo.ychip-1)) break;
      prtl=1;}
	  slitmin = (xdisper) ? ylcd-slitobj: xlcd-slitobj;
	  //"right"=maxvalue slit end
	  xr=mpright.x;
	  yr=mpright.y;
	  mskpos = get3de2v(mpright,0.0);
	  campos = Op_transform(mskpos,instrument,lambda,cur_temp);
	  xfp=campos.x;
	  yfp=campos.y;
	  chip1=fp2ccd(xfp,yfp,&xcd,&ycd,lambda);
    //does spectrum straddle 2 chips?
    if(abs(chip) != abs(chip1)) break;
    if(chip1<0){
      if(!useprtl) break;
      if(xdisper && (xcd<0 || xcd>=dewinfo.xchip-1)) break;
      if(!xdisper && (ycd<0 || ycd>=dewinfo.ychip-1)) break;
      prtl=1;}    
	  slitmax = (xdisper) ? ycd-slitobj: xcd-slitobj;
	  //slitlength in focal plane
	  slitln=sqrt((xl-xr)*(xl-xr)+(yl-yr)*(yl-yr));

	  //spectrum x,y location,y slitlength vs lambda
	if(xdisper){
	  yval[npxl]=yccd;
	  xval[npxl]=xccd;
	  slitlen[npxl]=ycd-ylcd;}
	else{
	  yval[npxl]=xccd;
	  xval[npxl]=yccd;
          slitlen[npxl]=xcd-xlcd;}
	lamval[npxl]=lambda;
      
	//curvature calculation
	
	//tilt
	mskpos=get3de2v(mpleft,0.0);
	campos = Op_transform(mskpos,instrument,lambda,cur_temp);
	xfp=campos.x;
	yfp=campos.y;
	chip1=fp2ccd(xfp,yfp,&xccd,&yccd,lambda);
  if(abs(chip)!=abs(chip1)) break;
	leftpos = (xdisper) ? xccd: yccd;
	mskpos=get3de2v(mpright,0.0);
	campos = Op_transform(mskpos,instrument,lambda,cur_temp);
	xfp=campos.x;
	yfp=campos.y;
	chip1=fp2ccd(xfp,yfp,&xccd,&yccd,lambda);
	if(abs(chip) !=abs(chip1)) break;
	rightpos = (xdisper) ? xccd: yccd;
	tilt[npxl]=(rightpos-leftpos);
	midpos = 0.5*(rightpos+leftpos);

	//curvature
	campos = Op_transform(cenpos,instrument,lambda,cur_temp);
	xfp=campos.x;
	yfp=campos.y;
	chip=fp2ccd(xfp,yfp,&xccd,&yccd,lambda);
	centr = (xdisper) ? xccd: yccd;
	sagit[npxl]=centr-midpos;
	lambda+=disper;
	lastchip=chip;
	npxl++;}
      if(!lastchip) continue;
      //hit end of chip
      if(npxl < minpixl)continue;

      /*------------fit and write data for spectrum segment------------------*/

      lamax=lambda-disper;
      if(!fsln){
        xfp=oq->smpos.x;
        yfp=oq->smpos.y;
        fprintf(outfile,"LENGTH = %f POS = %8.3f %8.3f\n",slitln,xfp,yfp);
	fsln=1;}
      fprintf(outfile,"CHIP %d %7.5f %7.5f %8.2f %8.2f %d %d\n",lastchip,
              slitmin,slitmax,lamin,lamax,npxl,prtl);
      nchp++;
      //dispersion solution
      plyfit(lamval,xval,npxl,ord_disper,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_disper;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      //inverse dispersion solution
      plyfit(xval,lamval,npxl,ord_disper,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_disper;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      //spectrum sag
      plyfit(lamval,yval,npxl,ord_sag,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_sag;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      //spectrum tilt
      plyfit(lamval,tilt,npxl,ord_tilt,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_tilt;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      //spectrum saggitta
      plyfit(lamval,sagit,npxl,ord_sagit,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_sagit;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      //slitlength
      plyfit(lamval,slitlen,npxl,ord_slen,coefs,xlist,ylist,elist);
      for(i=0;i<=ord_slen;i++) fprintf(outfile,"%13.6e ",coefs[i]);
      fprintf(outfile,"\n");
      }
    //bad slit
    if(!nchp)nbd++;
    oq=oq->next;
    mesage=0;
    if(oq==oq1) break;
    curslit++;}
  fprintf(outfile,"END\n\n");

  //free memory
  for(i=0;i<maxord;i++) free(*(elist+i));
  free(elist);
  free(xlist);
  free(ylist);
  free(xval);
  free(yval);
  free(tilt);
  free(sagit);
  free(lamval);
  free(slitlen);

  if(nbd){
    printf("\nThe following slits straddled a chip boundary, and were not mapped:\n\n");
    for(i=0;i<nbd;i++){
      printf("Slit %3d   %s\n",badnum[i],*(badname+i));}
    }
   return 0;}
