/*****************************************************************************\
*                                                                             *
*   READPARM   reads IRAF par files. readparm_s reads string values           *
*                                    readparm_i reads interger values         *
*				     readparm_r reads real values             *
*                                    readparm_b reads logical values          *
*                                                                             *
*                                    openparm must be called first            *
*                                                                             *
*                                    Parameters: parm: name of parameter      *
*                                                svalue,rvalue,ivalue: value  *
*                                                                             *
*                                    Return: 0 if successful, 1 if error      *
*                                                                             *
*   VERSION: 16 October 1995                                                  *
*                                                                             *
\*****************************************************************************/

#include  <stdlib.h>
#include  <string.h>
#include  <stdio.h>

static int    npar,nreal,nint,nchar,ivalue[100],i;
static float  rvalue[100];
static char   CHAR,keyword[100][41],cvalue[100][41],linetype[100],line[133];


int OpenParm(char filename[]){

  char        comment[41];
  char        *pt;
  FILE        *parmfile;

  if((parmfile=fopen(filename,"r")) == NULL) return 1;
  for(npar=0;npar<100;npar++){
    if(!fgets(line,133,parmfile)) break;
    if(!strcmp(line,"mode")) break;
    sscanf(line,"%[^,],%c",&keyword[npar][0],&linetype[npar]);
    pt=strstr(line,",h,")+3;
    switch(linetype[npar]){
      case 'r':
        sscanf(pt,"%f",&rvalue[npar]);
        break;
      case 'i':
        sscanf(pt,"%i",&ivalue[npar]);
        break;
      case 'f':
        sscanf(pt,"\"%[^\"]\"",&cvalue[npar]);
        break;
      case 's':
        sscanf(pt,"\"%[^\"]\"",&cvalue[npar]);
	break;
      case 'b':
        cvalue[npar][0]=*(pt);}
    }
   fclose(parmfile);
  return 0;
}



int ReadParm_s(char parm[], char ss[]){
 for(i=0;i<npar;i++){
    if(!strcmp(parm,keyword[i])){
      if(linetype[i] != 'f' && linetype[i] != 's') return 1;
      strcpy(ss,cvalue[i]);
      return 0;}
    }
  return 1;
}

int ReadParm_b(char parm[], int *ii){
 for(i=0;i<npar;i++){
    if(!strcmp(parm,keyword[i])){
      if(linetype[i] != 'b') return 1;
      *ii=0;
      if(cvalue[i][0]=='y' || cvalue[i][0]=='Y')*ii=1;
      return 0;}
    }
  return 1;
}

int ReadParm_i(char parm[], int *ii){

  for(i=0;i<npar;i++){
    if(!strcmp(parm,keyword[i])){
      if(linetype[i] != 'i') return 1;
      *ii=ivalue[i];
      return 0;}
    }
  return 1;
}


int ReadParm_r(char parm[], float *rr){

  for(i=0;i<npar;i++){
    if(!strcmp(parm,keyword[i])){
      if(linetype[i] != 'r') return 1;
      *rr=rvalue[i];
      return 0;}
    }
  return 1;
}
